/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class EventEntity
extends zzc
implements Event {
    public static final Parcelable.Creator<EventEntity> CREATOR = new zza();
    private final String zzhef;
    private final String mName;
    private final String zzdmu;
    private final Uri zzhbm;
    private final String zzhbx;
    private final PlayerEntity zzhea;
    private final long zzdmt;
    private final String zzheg;
    private final boolean zzavh;

    public EventEntity(Event event) {
        this.zzhef = event.getEventId();
        this.mName = event.getName();
        this.zzdmu = event.getDescription();
        this.zzhbm = event.getIconImageUri();
        this.zzhbx = event.getIconImageUrl();
        this.zzhea = (PlayerEntity)event.getPlayer().freeze();
        this.zzdmt = event.getValue();
        this.zzheg = event.getFormattedValue();
        this.zzavh = event.isVisible();
    }

    EventEntity(String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.zzhef = string;
        this.mName = string2;
        this.zzdmu = string3;
        this.zzhbm = uri;
        this.zzhbx = string4;
        this.zzhea = new PlayerEntity(player);
        this.zzdmt = l;
        this.zzheg = string5;
        this.zzavh = bl;
    }

    @Override
    public final String getEventId() {
        return this.zzhef;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdmu;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbm;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbx;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhea;
    }

    @Override
    public final long getValue() {
        return this.zzdmt;
    }

    @Override
    public final String getFormattedValue() {
        return this.zzheg;
    }

    @Override
    public final void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzheg, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final boolean isVisible() {
        return this.zzavh;
    }

    public final Event freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return Arrays.hashCode(new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public final boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzbf.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzbf.equal((Object)event2.getName(), (Object)event.getName()) && zzbf.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzbf.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzbf.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzbf.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzbf.equal((Object)event2.getValue(), (Object)event.getValue()) && zzbf.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzbf.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public final String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzbf.zzt((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        EventEntity eventEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)eventEntity.getEventId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)eventEntity.getName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)eventEntity.getDescription(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)eventEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (String)eventEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (Parcelable)eventEntity.getPlayer(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (long)eventEntity.getValue());
        zzbcn.zza((Parcel)parcel2, (int)8, (String)eventEntity.getFormattedValue(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)9, (boolean)eventEntity.isVisible());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

