/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzhfz;
    private final String zzebx;
    private final Uri zzhbm;
    private final Uri zzhbn;
    private final int zzbyz;
    private final String zzhmp;
    private final boolean zzhmq;
    private final PlayerEntity zzhea;
    private final int zzeiv;
    private final ParticipantResult zzhmr;
    private final String zzhbx;
    private final String zzhby;

    public ParticipantEntity(Participant participant) {
        this.zzhfz = participant.getParticipantId();
        this.zzebx = participant.getDisplayName();
        this.zzhbm = participant.getIconImageUri();
        this.zzhbn = participant.getHiResImageUri();
        this.zzbyz = participant.getStatus();
        this.zzhmp = participant.zzarv();
        this.zzhmq = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzhea = player == null ? null : new PlayerEntity(player);
        this.zzeiv = participant.getCapabilities();
        this.zzhmr = participant.getResult();
        this.zzhbx = participant.getIconImageUrl();
        this.zzhby = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzhfz = string;
        this.zzebx = string2;
        this.zzhbm = uri;
        this.zzhbn = uri2;
        this.zzbyz = n;
        this.zzhmp = string3;
        this.zzhmq = bl;
        this.zzhea = playerEntity;
        this.zzeiv = n2;
        this.zzhmr = participantResult;
        this.zzhbx = string4;
        this.zzhby = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzbyz;
    }

    @Override
    public final String zzarv() {
        return this.zzhmp;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzhmq;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzhea == null) {
            return this.zzebx;
        }
        return this.zzhea.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhea == null) {
            zzg.zzb((String)this.zzebx, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhea.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzhea == null) {
            return this.zzhbm;
        }
        return this.zzhea.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzhea == null) {
            return this.zzhbx;
        }
        return this.zzhea.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzhea == null) {
            return this.zzhbn;
        }
        return this.zzhea.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzhea == null) {
            return this.zzhby;
        }
        return this.zzhea.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzhfz;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhea;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzhmr;
    }

    @Override
    public final int getCapabilities() {
        return this.zzeiv;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzarv(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbf.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbf.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbf.equal((Object)participant2.zzarv(), (Object)participant.zzarv()) && zzbf.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbf.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbf.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbf.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbf.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbf.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbf.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbf.zzt((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzarv()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzbcn.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzhmp, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzeiv);
        zzbcn.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzl(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzakc()) || ParticipantEntity.zzgb((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzl(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzc)this).zzl(parcel);
        }
    }
}

