/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.zze;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new zza();
    private final String zzhff;
    private final String zzhnf;
    private final long mCreationTimestamp;
    private final int zzhng;
    private final String zzdmu;
    private final int zzhmm;
    private final Bundle zzhnd;
    private final ArrayList<ParticipantEntity> zzhml;
    private final int zzhnh;

    public RoomEntity(Room room) {
        this.zzhff = room.getRoomId();
        this.zzhnf = room.getCreatorId();
        this.mCreationTimestamp = room.getCreationTimestamp();
        this.zzhng = room.getStatus();
        this.zzdmu = room.getDescription();
        this.zzhmm = room.getVariant();
        this.zzhnd = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzhml = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhml.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzhnh = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(String string, String string2, long l, int n, String string3, int n2, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n3) {
        this.zzhff = string;
        this.zzhnf = string2;
        this.mCreationTimestamp = l;
        this.zzhng = n;
        this.zzdmu = string3;
        this.zzhmm = n2;
        this.zzhnd = bundle;
        this.zzhml = arrayList;
        this.zzhnh = n3;
    }

    @Override
    public final String getRoomId() {
        return this.zzhff;
    }

    @Override
    public final String getCreatorId() {
        return this.zzhnf;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final int getStatus() {
        return this.zzhng;
    }

    @Override
    public final String getDescription() {
        return this.zzdmu;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzhmm;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzhnd;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzhml);
    }

    @Override
    public final int getAutoMatchWaitEstimateSeconds() {
        return this.zzhnh;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public final Room freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return Arrays.hashCode(new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public final boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzbf.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzbf.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzbf.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzbf.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzbf.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzbf.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzbf.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzbf.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzbf.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public final String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzbf.zzt((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RoomEntity roomEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)roomEntity.getRoomId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)roomEntity.getCreatorId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (long)roomEntity.getCreationTimestamp());
        zzbcn.zzc((Parcel)parcel2, (int)4, (int)roomEntity.getStatus());
        zzbcn.zza((Parcel)parcel2, (int)5, (String)roomEntity.getDescription(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)roomEntity.getVariant());
        zzbcn.zza((Parcel)parcel2, (int)7, (Bundle)roomEntity.getAutoMatchCriteria(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)8, roomEntity.getParticipants(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, (int)roomEntity.getAutoMatchWaitEstimateSeconds());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = room.getRoomId();
        throw new IllegalStateException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in room ").append(string2).toString());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = room.getRoomId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static final class zza
    extends zze {
        zza() {
        }

        @Override
        public final RoomEntity zzm(Parcel parcel) {
            if (RoomEntity.zze(RoomEntity.zzakc()) || RoomEntity.zzgb((String)RoomEntity.class.getCanonicalName())) {
                return super.zzm(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            String string3 = parcel.readString();
            int n2 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(string, string2, l, n, string3, n2, bundle, arrayList, -1);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zze)this).zzm(parcel);
        }
    }
}

