/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;

public final class TurnBasedMatchEntity
extends com.google.android.gms.games.internal.zzc
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new zzc();
    private final GameEntity zzhjf;
    private final String zzhfr;
    private final String zzhnf;
    private final long mCreationTimestamp;
    private final String zzhnn;
    private final long zzhed;
    private final String zzhno;
    private final int zzhnp;
    private final int zzhmm;
    private final int mVersion;
    private final byte[] zzhnq;
    private final ArrayList<ParticipantEntity> zzhml;
    private final String zzhnr;
    private final byte[] zzhns;
    private final int zzhnt;
    private final Bundle zzhnd;
    private final int zzhnu;
    private final boolean zzhnv;
    private final String zzdmu;
    private final String zzhnw;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.zzhjf = new GameEntity(turnBasedMatch.getGame());
        this.zzhfr = turnBasedMatch.getMatchId();
        this.zzhnf = turnBasedMatch.getCreatorId();
        this.mCreationTimestamp = turnBasedMatch.getCreationTimestamp();
        this.zzhnn = turnBasedMatch.getLastUpdaterId();
        this.zzhed = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzhno = turnBasedMatch.getPendingParticipantId();
        this.zzhnp = turnBasedMatch.getStatus();
        this.zzhnu = turnBasedMatch.getTurnStatus();
        this.zzhmm = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzhnr = turnBasedMatch.getRematchId();
        this.zzhnt = turnBasedMatch.getMatchNumber();
        this.zzhnd = turnBasedMatch.getAutoMatchCriteria();
        this.zzhnv = turnBasedMatch.isLocallyModified();
        this.zzdmu = turnBasedMatch.getDescription();
        this.zzhnw = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzhnq = null;
        } else {
            this.zzhnq = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhnq, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzhns = null;
        } else {
            this.zzhns = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzhns, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzhml = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhml.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n, int n2, int n3, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n4, Bundle bundle, int n5, boolean bl, String string6, String string7) {
        this.zzhjf = gameEntity;
        this.zzhfr = string;
        this.zzhnf = string2;
        this.mCreationTimestamp = l;
        this.zzhnn = string3;
        this.zzhed = l2;
        this.zzhno = string4;
        this.zzhnp = n;
        this.zzhnu = n5;
        this.zzhmm = n2;
        this.mVersion = n3;
        this.zzhnq = byArray;
        this.zzhml = arrayList;
        this.zzhnr = string5;
        this.zzhns = byArray2;
        this.zzhnt = n4;
        this.zzhnd = bundle;
        this.zzhnv = bl;
        this.zzdmu = string6;
        this.zzhnw = string7;
    }

    @Override
    public final Game getGame() {
        return this.zzhjf;
    }

    @Override
    public final String getMatchId() {
        return this.zzhfr;
    }

    @Override
    public final String getCreatorId() {
        return this.zzhnf;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final String getLastUpdaterId() {
        return this.zzhnn;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhed;
    }

    @Override
    public final String getPendingParticipantId() {
        return this.zzhno;
    }

    @Override
    public final int getStatus() {
        return this.zzhnp;
    }

    @Override
    public final int getTurnStatus() {
        return this.zzhnu;
    }

    @Override
    public final String getDescription() {
        return this.zzdmu;
    }

    @Override
    public final String getDescriptionParticipantId() {
        return this.zzhnw;
    }

    @Override
    public final Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzhmm;
    }

    @Override
    public final byte[] getData() {
        return this.zzhnq;
    }

    @Override
    public final int getVersion() {
        return this.mVersion;
    }

    @Override
    public final String getRematchId() {
        return this.zzhnr;
    }

    @Override
    public final byte[] getPreviousMatchData() {
        return this.zzhns;
    }

    @Override
    public final int getMatchNumber() {
        return this.zzhnt;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzhnd;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (this.zzhnd == null) {
            return 0;
        }
        return this.zzhnd.getInt("max_automatch_players");
    }

    @Override
    public final boolean canRematch() {
        return this.zzhnp == 2 && this.zzhnr == null;
    }

    @Override
    public final boolean isLocallyModified() {
        return this.zzhnv;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzhml);
    }

    public final TurnBasedMatch freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return Arrays.hashCode(new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public final boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzbf.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzbf.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzbf.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzbf.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzbf.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzbf.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzbf.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzbf.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzbf.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzbf.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzbf.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzbf.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzbf.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzbf.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzbf.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzbf.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzbf.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzbf.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public final String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzbf.zzt((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TurnBasedMatchEntity turnBasedMatchEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (Parcelable)turnBasedMatchEntity.getGame(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)turnBasedMatchEntity.getMatchId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)turnBasedMatchEntity.getCreatorId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (long)turnBasedMatchEntity.getCreationTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)5, (String)turnBasedMatchEntity.getLastUpdaterId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (long)turnBasedMatchEntity.getLastUpdatedTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)7, (String)turnBasedMatchEntity.getPendingParticipantId(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)8, (int)turnBasedMatchEntity.getStatus());
        zzbcn.zzc((Parcel)parcel2, (int)10, (int)turnBasedMatchEntity.getVariant());
        zzbcn.zzc((Parcel)parcel2, (int)11, (int)turnBasedMatchEntity.getVersion());
        zzbcn.zza((Parcel)parcel2, (int)12, (byte[])turnBasedMatchEntity.getData(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)13, turnBasedMatchEntity.getParticipants(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)14, (String)turnBasedMatchEntity.getRematchId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)15, (byte[])turnBasedMatchEntity.getPreviousMatchData(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)16, (int)turnBasedMatchEntity.getMatchNumber());
        zzbcn.zza((Parcel)parcel2, (int)17, (Bundle)turnBasedMatchEntity.getAutoMatchCriteria(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)18, (int)turnBasedMatchEntity.getTurnStatus());
        zzbcn.zza((Parcel)parcel2, (int)19, (boolean)turnBasedMatchEntity.isLocallyModified());
        zzbcn.zza((Parcel)parcel2, (int)20, (String)turnBasedMatchEntity.getDescription(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)21, (String)turnBasedMatchEntity.getDescriptionParticipantId(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

