/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzarz();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdmu;
        private Long zzhor;
        private Long zzhos;
        private BitmapTeleporter zzhot;
        private Uri zzhou;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdmu = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzhor = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzhos = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzhot = new BitmapTeleporter(bitmap);
            this.zzhou = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdmu = snapshotMetadata.getDescription();
            this.zzhor = snapshotMetadata.getPlayedTime();
            this.zzhos = snapshotMetadata.getProgressValue();
            if (this.zzhor == -1L) {
                this.zzhor = null;
            }
            this.zzhou = snapshotMetadata.getCoverImageUri();
            if (this.zzhou != null) {
                this.zzhot = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdmu, this.zzhor, this.zzhot, this.zzhou, this.zzhos);
        }
    }
}

