/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.games.video.zzb;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;

public final class VideoConfiguration
extends zzbck {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzhqa;
    private final int zzhpt;
    private final String zzhqb;
    private final String zzhqc;
    private final String zzhqd;
    private final String zzhqe;
    private final boolean zzhqf;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbp.zzbh((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbp.zzbh((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzhqa = n;
        this.zzhpt = n2;
        this.zzhqf = bl;
        if (n2 == 1) {
            this.zzhqc = string2;
            this.zzhqb = string;
            this.zzhqd = string3;
            this.zzhqe = string4;
            return;
        }
        zzbp.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbp.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbp.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbp.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzhqc = null;
        this.zzhqb = null;
        this.zzhqd = null;
        this.zzhqe = null;
    }

    public final int getQualityLevel() {
        return this.zzhqa;
    }

    public final int getCaptureMode() {
        return this.zzhpt;
    }

    public final String getStreamUrl() {
        return this.zzhqb;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzhqc, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzhqd, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzhqe, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzhqf);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzhqa;
        private int zzhpt;
        private boolean zzhqf;
        private String zzhqb;
        private String zzhqc;
        private String zzhqd;
        private String zzhqe;

        public Builder(int n, int n2) {
            this.zzhqa = n;
            this.zzhpt = n2;
            this.zzhqf = true;
            this.zzhqb = null;
            this.zzhqc = null;
            this.zzhqd = null;
            this.zzhqe = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzhqa = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzhpt = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzhqa, this.zzhpt, null, null, null, null, this.zzhqf);
        }
    }
}

