/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzaub();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdou;
        private Long zzhxm;
        private Long zzhxn;
        private BitmapTeleporter zzhxo;
        private Uri zzhxp;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdou = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzhxm = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzhxn = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzhxo = new BitmapTeleporter(bitmap);
            this.zzhxp = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdou = snapshotMetadata.getDescription();
            this.zzhxm = snapshotMetadata.getPlayedTime();
            this.zzhxn = snapshotMetadata.getProgressValue();
            if (this.zzhxm == -1L) {
                this.zzhxm = null;
            }
            this.zzhxp = snapshotMetadata.getCoverImageUri();
            if (this.zzhxp != null) {
                this.zzhxo = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdou, this.zzhxm, this.zzhxo, this.zzhxp, this.zzhxn);
        }
    }
}

