/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.zza;
import com.google.android.gms.games.zzb;
import com.google.android.gms.games.zzc;
import com.google.android.gms.games.zzd;
import com.google.android.gms.games.zze;
import com.google.android.gms.tasks.Task;

public class AchievementsClient
extends com.google.android.gms.games.internal.api.zzp {
    private static final zzbo<Achievements.LoadAchievementsResult, AchievementBuffer> zzhgk = new zzb();
    private static final zzbo<Achievements.UpdateAchievementResult, Void> zzhgl = new zzc();
    private static final zzbo<Achievements.UpdateAchievementResult, Boolean> zzhgm = new zzd();
    private static final zzp zzhgn = new zze();

    AchievementsClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    AchievementsClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getAchievementsIntent() {
        return this.zza(new zza(this));
    }

    public Task<AnnotatedData<AchievementBuffer>> load(boolean bl) {
        return zzg.zzc(Games.Achievements.load(this.zzagb(), bl), zzhgk);
    }

    public void reveal(@NonNull String string) {
        Games.Achievements.reveal(this.zzagb(), string);
    }

    public Task<Void> revealImmediate(@NonNull String string) {
        return AchievementsClient.zzc(Games.Achievements.revealImmediate(this.zzagb(), string));
    }

    public void unlock(@NonNull String string) {
        Games.Achievements.unlock(this.zzagb(), string);
    }

    public Task<Void> unlockImmediate(@NonNull String string) {
        return AchievementsClient.zzc(Games.Achievements.unlockImmediate(this.zzagb(), string));
    }

    public void increment(@NonNull String string, @IntRange(from=0L) int n) {
        Games.Achievements.increment(this.zzagb(), string, n);
    }

    public Task<Boolean> incrementImmediate(@NonNull String string, @IntRange(from=0L) int n) {
        return AchievementsClient.zzd(Games.Achievements.incrementImmediate(this.zzagb(), string, n));
    }

    public void setSteps(@NonNull String string, @IntRange(from=0L) int n) {
        Games.Achievements.setSteps(this.zzagb(), string, n);
    }

    public Task<Boolean> setStepsImmediate(@NonNull String string, @IntRange(from=0L) int n) {
        return AchievementsClient.zzd(Games.Achievements.setStepsImmediate(this.zzagb(), string, n));
    }

    private static Task<Void> zzc(@NonNull PendingResult<Achievements.UpdateAchievementResult> pendingResult) {
        return zzg.zza(pendingResult, zzhgn, zzhgl);
    }

    private static Task<Boolean> zzd(@NonNull PendingResult<Achievements.UpdateAchievementResult> pendingResult) {
        return zzg.zza(pendingResult, zzhgn, zzhgm);
    }
}

