/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.api.zzp;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.zzh;
import com.google.android.gms.games.zzaz;
import com.google.android.gms.games.zzba;
import com.google.android.gms.games.zzbb;
import com.google.android.gms.games.zzbc;
import com.google.android.gms.games.zzbd;
import com.google.android.gms.games.zzbe;
import com.google.android.gms.games.zzbf;
import com.google.android.gms.games.zzbh;
import com.google.android.gms.games.zzbi;
import com.google.android.gms.games.zzbj;
import com.google.android.gms.games.zzbk;
import com.google.android.gms.games.zzbl;
import com.google.android.gms.games.zzbm;
import com.google.android.gms.games.zzbp;
import com.google.android.gms.games.zzbq;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import java.util.List;

public class RealTimeMultiplayerClient
extends zzp {
    RealTimeMultiplayerClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    RealTimeMultiplayerClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getWaitingRoomIntent(@NonNull Room room, @IntRange(from=0L) int n) {
        return this.zza(new zzaz(this, room, n));
    }

    public Task<Intent> getSelectOpponentsIntent(@IntRange(from=1L) int n, @IntRange(from=1L) int n2) {
        return this.getSelectOpponentsIntent(n, n2, true);
    }

    public Task<Intent> getSelectOpponentsIntent(@IntRange(from=1L) int n, @IntRange(from=1L) int n2, boolean bl) {
        return this.zza(new zzbh(this, n, n2, bl));
    }

    public Task<Void> create(@NonNull RoomConfig roomConfig) {
        zzh zzh2 = roomConfig.zzatw();
        zzcl zzcl2 = this.zza(zzh2, zzh.class.getSimpleName());
        zzbi zzbi2 = new zzbi(this, zzcl2, zzcl2, roomConfig);
        zzbj zzbj2 = new zzbj(this, zzcl2.zzajc());
        return this.zza(zzbi2, zzbj2);
    }

    public Task<Void> join(@NonNull RoomConfig roomConfig) {
        zzh zzh2 = roomConfig.zzatw();
        zzcl zzcl2 = this.zza(zzh2, zzh.class.getSimpleName());
        zzbk zzbk2 = new zzbk(this, zzcl2, zzcl2, roomConfig);
        zzbl zzbl2 = new zzbl(this, zzcl2.zzajc());
        return this.zza(zzbk2, zzbl2);
    }

    public Task<Void> leave(@NonNull RoomConfig roomConfig, @NonNull String string) {
        zzcl zzcl2 = this.zza(roomConfig.zzatw(), zzh.class.getSimpleName());
        String string2 = string;
        RealTimeMultiplayerClient realTimeMultiplayerClient = this;
        return realTimeMultiplayerClient.zza(new zzbf(realTimeMultiplayerClient, string2)).continueWithTask((Continuation)new zzbp(this, zzcl2)).continueWithTask((Continuation)new zzbm(this, zzcl2, string, roomConfig));
    }

    public Task<Integer> sendReliableMessage(@NonNull byte[] byArray, @NonNull String string, @NonNull String string2, @Nullable ReliableMessageSentCallback reliableMessageSentCallback) {
        zzcl zzcl2 = null;
        if (reliableMessageSentCallback != null) {
            zzcl2 = zzcp.zzb((Object)reliableMessageSentCallback, (Looper)Looper.getMainLooper(), (String)ReliableMessageSentCallback.class.getSimpleName());
        }
        zzcl zzcl3 = zzcl2;
        return this.zzb(new zzbq(this, zzcl3, byArray, string, string2));
    }

    public Task<Void> sendUnreliableMessage(@NonNull byte[] byArray, @NonNull String string, @NonNull String string2) {
        return this.zzb(new zzba(this, byArray, string, string2));
    }

    public Task<Void> sendUnreliableMessage(@NonNull byte[] byArray, @NonNull String string, @NonNull List<String> list) {
        return this.zzb(new zzbb(this, list, byArray, string));
    }

    public Task<Void> sendUnreliableMessageToOthers(@NonNull byte[] byArray, @NonNull String string) {
        return this.zzb(new zzbc(this, byArray, string));
    }

    public Task<Void> declineInvitation(@NonNull String string) {
        return this.zzb(new zzbd(this, string));
    }

    public Task<Void> dismissInvitation(@NonNull String string) {
        return this.zzb(new zzbe(this, string));
    }

    public static interface ReliableMessageSentCallback
    extends RealTimeMultiplayer.ReliableMessageSentCallback {
        @Override
        public void onRealTimeMessageSent(int var1, int var2, String var3);
    }
}

