/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzhtp;
    private final String zzhtq;
    private final String zzhtr;
    private final long zzhts;
    private final long zzhtt;
    private final String zzhtu;
    private final Uri zzhtv;
    private final Uri zzhtw;
    private final PlayerEntity zzhtx;
    private final String zzhty;
    private final String zzhtz;
    private final String zzhua;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzhtp = leaderboardScore.getRank();
        this.zzhtq = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayRank());
        this.zzhtr = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayScore());
        this.zzhts = leaderboardScore.getRawScore();
        this.zzhtt = leaderboardScore.getTimestampMillis();
        this.zzhtu = leaderboardScore.getScoreHolderDisplayName();
        this.zzhtv = leaderboardScore.getScoreHolderIconImageUri();
        this.zzhtw = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzhtx = player == null ? null : (PlayerEntity)player.freeze();
        this.zzhty = leaderboardScore.getScoreTag();
        this.zzhtz = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzhua = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzhtp;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzhtq;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhtq, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzhtr;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhtr, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzhts;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzhtt;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzhtx == null) {
            return this.zzhtu;
        }
        return this.zzhtx.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhtx == null) {
            zzg.zzb((String)this.zzhtu, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhtx.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzhtx == null) {
            return this.zzhtv;
        }
        return this.zzhtx.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzhtx == null) {
            return this.zzhtz;
        }
        return this.zzhtx.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzhtx == null) {
            return this.zzhtw;
        }
        return this.zzhtx.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzhtx == null) {
            return this.zzhua;
        }
        return this.zzhtx.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzhtx;
    }

    @Override
    public final String getScoreTag() {
        return this.zzhty;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbg.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbg.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbg.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbg.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbg.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbg.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbg.zzw((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

