/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantRef
extends zzc
implements Participant {
    private final PlayerRef zzhuy;

    public ParticipantRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzhuy = new PlayerRef(dataHolder, n);
    }

    @Override
    public final int getStatus() {
        return this.getInteger("player_status");
    }

    @Override
    public final String zzatv() {
        return this.getString("client_address");
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.getInteger("connected") > 0;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzfx("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzhuy.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzfx("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.zzhuy.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzfx("external_player_id")) {
            return this.zzfw("default_display_image_uri");
        }
        return this.zzhuy.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzfx("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzhuy.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzfx("external_player_id")) {
            return this.zzfw("default_display_hi_res_image_uri");
        }
        return this.zzhuy.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzfx("external_player_id")) {
            return this.getString("default_display_hi_res_image_url");
        }
        return this.zzhuy.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.getString("external_participant_id");
    }

    @Override
    public final Player getPlayer() {
        if (this.zzfx("external_player_id")) {
            return null;
        }
        return this.zzhuy;
    }

    @Override
    public final ParticipantResult getResult() {
        if (this.zzfx("result_type")) {
            return null;
        }
        int n = this.getInteger("result_type");
        int n2 = this.getInteger("placing");
        return new ParticipantResult(this.getParticipantId(), n, n2);
    }

    @Override
    public final int getCapabilities() {
        return this.getInteger("capabilities");
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((ParticipantEntity)((Participant)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        ParticipantRef participantRef = this;
        return new ParticipantEntity(participantRef);
    }
}

