/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zzf;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzhvt;
    private final TurnBasedMatchBuffer zzhvu;
    private final TurnBasedMatchBuffer zzhvv;
    private final TurnBasedMatchBuffer zzhvw;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzhvt = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzhvu = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzhvv = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzhvw = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzhvw = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zzf.zzw("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzhvt;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzhvu;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzhvv;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzhvw;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzhvt != null) {
            this.zzhvt.release();
        }
        if (this.zzhvu != null) {
            this.zzhvu.release();
        }
        if (this.zzhvv != null) {
            this.zzhvv.release();
        }
        if (this.zzhvw != null) {
            this.zzhvw.release();
        }
    }

    public final boolean hasData() {
        if (this.zzhvt != null && this.zzhvt.getCount() > 0) {
            return true;
        }
        if (this.zzhvu != null && this.zzhvu.getCount() > 0) {
            return true;
        }
        if (this.zzhvv != null && this.zzhvv.getCount() > 0) {
            return true;
        }
        return this.zzhvw != null && this.zzhvw.getCount() > 0;
    }
}

