/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhot;
    private final int zzeie;
    private final String mName;
    private final String zzdrs;
    private final Uri zzhou;
    private final String zzhov;
    private final Uri zzhow;
    private final String zzhox;
    private final int zzhoy;
    private final String zzhoz;
    private final PlayerEntity zzhpa;
    private final int mState;
    private final int zzhpb;
    private final String zzhpc;
    private final long zzhpd;
    private final long zzhpe;

    public AchievementEntity(Achievement achievement) {
        this.zzhot = achievement.getAchievementId();
        this.zzeie = achievement.getType();
        this.mName = achievement.getName();
        this.zzdrs = achievement.getDescription();
        this.zzhou = achievement.getUnlockedImageUri();
        this.zzhov = achievement.getUnlockedImageUrl();
        this.zzhow = achievement.getRevealedImageUri();
        this.zzhox = achievement.getRevealedImageUrl();
        this.zzhpa = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhpd = achievement.getLastUpdatedTimestamp();
        this.zzhpe = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhoy = achievement.getTotalSteps();
            this.zzhoz = achievement.getFormattedTotalSteps();
            this.zzhpb = achievement.getCurrentSteps();
            this.zzhpc = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhoy = 0;
            this.zzhoz = null;
            this.zzhpb = 0;
            this.zzhpc = null;
        }
        com.google.android.gms.common.internal.zzc.zzv((Object)this.zzhot);
        com.google.android.gms.common.internal.zzc.zzv((Object)this.zzdrs);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhot = string;
        this.zzeie = n;
        this.mName = string2;
        this.zzdrs = string3;
        this.zzhou = uri;
        this.zzhov = string4;
        this.zzhow = uri2;
        this.zzhox = string5;
        this.zzhoy = n2;
        this.zzhoz = string6;
        this.zzhpa = playerEntity;
        this.mState = n3;
        this.zzhpb = n4;
        this.zzhpc = string7;
        this.zzhpd = l;
        this.zzhpe = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhot;
    }

    @Override
    public final int getType() {
        return this.zzeie;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdrs;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdrs, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhou;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhov;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhow;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhox;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhoy;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhoz;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhoz, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhpa;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhpb;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhpc;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhpc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhpd;
    }

    @Override
    public final long getXpValue() {
        return this.zzhpe;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbg.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbg.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbg.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbg.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbg.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbg.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbg.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbg.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbg.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbg.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbi zzbi2 = zzbg.zzx((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbi2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbi2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbi2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbfp.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhoy);
        zzbfp.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhoz, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbfp.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzhpb);
        zzbfp.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzhpc, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

