/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new zza();
    private final GameEntity zzhug;
    private final String zzebl;
    private final long mCreationTimestamp;
    private final int zzhxk;
    private final ParticipantEntity zzhxl;
    private final ArrayList<ParticipantEntity> zzhxm;
    private final int zzhxn;
    private final int zzhxo;

    InvitationEntity(Invitation invitation) {
        this.zzhug = new GameEntity(invitation.getGame());
        this.zzebl = invitation.getInvitationId();
        this.mCreationTimestamp = invitation.getCreationTimestamp();
        this.zzhxk = invitation.getInvitationType();
        this.zzhxn = invitation.getVariant();
        this.zzhxo = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzhxm = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzhxm.add((ParticipantEntity)participant2.freeze());
        }
        zzbq.checkNotNull(participant, (Object)"Must have a valid inviter!");
        this.zzhxl = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(GameEntity gameEntity, String string, long l, int n, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n2, int n3) {
        this.zzhug = gameEntity;
        this.zzebl = string;
        this.mCreationTimestamp = l;
        this.zzhxk = n;
        this.zzhxl = participantEntity;
        this.zzhxm = arrayList;
        this.zzhxn = n2;
        this.zzhxo = n3;
    }

    @Override
    public final Game getGame() {
        return this.zzhug;
    }

    @Override
    public final String getInvitationId() {
        return this.zzebl;
    }

    @Override
    public final Participant getInviter() {
        return this.zzhxl;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzhxm);
    }

    @Override
    public final int getInvitationType() {
        return this.zzhxk;
    }

    @Override
    public final int getVariant() {
        return this.zzhxn;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        return this.zzhxo;
    }

    public final Invitation freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return Arrays.hashCode(new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public final boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzbg.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzbg.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzbg.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzbg.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzbg.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzbg.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzbg.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzbg.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public final String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzbg.zzx((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        InvitationEntity invitationEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)invitationEntity.getGame(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)invitationEntity.getInvitationId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)invitationEntity.getCreationTimestamp());
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)invitationEntity.getInvitationType());
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)invitationEntity.getInviter(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)6, invitationEntity.getParticipants(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)invitationEntity.getVariant());
        zzbfp.zzc((Parcel)parcel2, (int)8, (int)invitationEntity.getAvailableAutoMatchSlots());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends com.google.android.gms.games.multiplayer.zza {
        zza() {
        }

        @Override
        public final InvitationEntity zzk(Parcel parcel) {
            if (InvitationEntity.zze(InvitationEntity.zzalg()) || InvitationEntity.zzgh((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzk(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(gameEntity, string, l, n, participantEntity, arrayList, -1, 0);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((com.google.android.gms.games.multiplayer.zza)this).zzk(parcel);
        }
    }
}

