/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzhrb;
    private final String zzegt;
    private final Uri zzhjq;
    private final Uri zzhjr;
    private final int zzcbc;
    private final String zzhxq;
    private final boolean zzhxr;
    private final PlayerEntity zzhpa;
    private final int zzeoe;
    private final ParticipantResult zzhxs;
    private final String zzhkb;
    private final String zzhkc;

    public ParticipantEntity(Participant participant) {
        this.zzhrb = participant.getParticipantId();
        this.zzegt = participant.getDisplayName();
        this.zzhjq = participant.getIconImageUri();
        this.zzhjr = participant.getHiResImageUri();
        this.zzcbc = participant.getStatus();
        this.zzhxq = participant.zzauh();
        this.zzhxr = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzhpa = player == null ? null : new PlayerEntity(player);
        this.zzeoe = participant.getCapabilities();
        this.zzhxs = participant.getResult();
        this.zzhkb = participant.getIconImageUrl();
        this.zzhkc = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzhrb = string;
        this.zzegt = string2;
        this.zzhjq = uri;
        this.zzhjr = uri2;
        this.zzcbc = n;
        this.zzhxq = string3;
        this.zzhxr = bl;
        this.zzhpa = playerEntity;
        this.zzeoe = n2;
        this.zzhxs = participantResult;
        this.zzhkb = string4;
        this.zzhkc = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzcbc;
    }

    @Override
    public final String zzauh() {
        return this.zzhxq;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzhxr;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzhpa == null) {
            return this.zzegt;
        }
        return this.zzhpa.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhpa == null) {
            zzg.zzb((String)this.zzegt, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhpa.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzhpa == null) {
            return this.zzhjq;
        }
        return this.zzhpa.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzhpa == null) {
            return this.zzhkb;
        }
        return this.zzhpa.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzhpa == null) {
            return this.zzhjr;
        }
        return this.zzhpa.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzhpa == null) {
            return this.zzhkc;
        }
        return this.zzhpa.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzhrb;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhpa;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzhxs;
    }

    @Override
    public final int getCapabilities() {
        return this.zzeoe;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzauh(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbg.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbg.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbg.equal((Object)participant2.zzauh(), (Object)participant.zzauh()) && zzbg.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbg.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbg.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbg.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbg.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbg.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbg.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbg.zzx((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzauh()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzbfp.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzhxq, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzbfp.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzeoe);
        zzbfp.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzl(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzalg()) || ParticipantEntity.zzgh((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzl(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzc)this).zzl(parcel);
        }
    }
}

