/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.zzc;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;

public final class TurnBasedMatchEntity
extends com.google.android.gms.games.internal.zzc
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new zzc();
    private final GameEntity zzhug;
    private final String zzhqt;
    private final String zzhyk;
    private final long mCreationTimestamp;
    private final String zzhyt;
    private final long zzhpd;
    private final String zzhyu;
    private final int zzhyv;
    private final int zzhxn;
    private final int mVersion;
    private final byte[] zzhyw;
    private final ArrayList<ParticipantEntity> zzhxm;
    private final String zzhyx;
    private final byte[] zzhyy;
    private final int zzhyz;
    private final Bundle zzhyh;
    private final int zzhza;
    private final boolean zzhzb;
    private final String zzdrs;
    private final String zzhzc;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.zzhug = new GameEntity(turnBasedMatch.getGame());
        this.zzhqt = turnBasedMatch.getMatchId();
        this.zzhyk = turnBasedMatch.getCreatorId();
        this.mCreationTimestamp = turnBasedMatch.getCreationTimestamp();
        this.zzhyt = turnBasedMatch.getLastUpdaterId();
        this.zzhpd = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzhyu = turnBasedMatch.getPendingParticipantId();
        this.zzhyv = turnBasedMatch.getStatus();
        this.zzhza = turnBasedMatch.getTurnStatus();
        this.zzhxn = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzhyx = turnBasedMatch.getRematchId();
        this.zzhyz = turnBasedMatch.getMatchNumber();
        this.zzhyh = turnBasedMatch.getAutoMatchCriteria();
        this.zzhzb = turnBasedMatch.isLocallyModified();
        this.zzdrs = turnBasedMatch.getDescription();
        this.zzhzc = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzhyw = null;
        } else {
            this.zzhyw = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhyw, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzhyy = null;
        } else {
            this.zzhyy = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzhyy, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzhxm = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhxm.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n, int n2, int n3, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n4, Bundle bundle, int n5, boolean bl, String string6, String string7) {
        this.zzhug = gameEntity;
        this.zzhqt = string;
        this.zzhyk = string2;
        this.mCreationTimestamp = l;
        this.zzhyt = string3;
        this.zzhpd = l2;
        this.zzhyu = string4;
        this.zzhyv = n;
        this.zzhza = n5;
        this.zzhxn = n2;
        this.mVersion = n3;
        this.zzhyw = byArray;
        this.zzhxm = arrayList;
        this.zzhyx = string5;
        this.zzhyy = byArray2;
        this.zzhyz = n4;
        this.zzhyh = bundle;
        this.zzhzb = bl;
        this.zzdrs = string6;
        this.zzhzc = string7;
    }

    @Override
    public final Game getGame() {
        return this.zzhug;
    }

    @Override
    public final String getMatchId() {
        return this.zzhqt;
    }

    @Override
    public final String getCreatorId() {
        return this.zzhyk;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final String getLastUpdaterId() {
        return this.zzhyt;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhpd;
    }

    @Override
    public final String getPendingParticipantId() {
        return this.zzhyu;
    }

    @Override
    public final int getStatus() {
        return this.zzhyv;
    }

    @Override
    public final int getTurnStatus() {
        return this.zzhza;
    }

    @Override
    public final String getDescription() {
        return this.zzdrs;
    }

    @Override
    public final String getDescriptionParticipantId() {
        return this.zzhzc;
    }

    @Override
    public final Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdrs, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzhxn;
    }

    @Override
    public final byte[] getData() {
        return this.zzhyw;
    }

    @Override
    public final int getVersion() {
        return this.mVersion;
    }

    @Override
    public final String getRematchId() {
        return this.zzhyx;
    }

    @Override
    public final byte[] getPreviousMatchData() {
        return this.zzhyy;
    }

    @Override
    public final int getMatchNumber() {
        return this.zzhyz;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzhyh;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (this.zzhyh == null) {
            return 0;
        }
        return this.zzhyh.getInt("max_automatch_players");
    }

    @Override
    public final boolean canRematch() {
        return this.zzhyv == 2 && this.zzhyx == null;
    }

    @Override
    public final boolean isLocallyModified() {
        return this.zzhzb;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzhxm);
    }

    public final TurnBasedMatch freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return Arrays.hashCode(new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public final boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzbg.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzbg.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzbg.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzbg.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzbg.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzbg.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzbg.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzbg.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzbg.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzbg.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzbg.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzbg.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzbg.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzbg.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzbg.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzbg.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzbg.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzbg.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public final String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzbg.zzx((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TurnBasedMatchEntity turnBasedMatchEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)turnBasedMatchEntity.getGame(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)turnBasedMatchEntity.getMatchId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)turnBasedMatchEntity.getCreatorId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (long)turnBasedMatchEntity.getCreationTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)5, (String)turnBasedMatchEntity.getLastUpdaterId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (long)turnBasedMatchEntity.getLastUpdatedTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)7, (String)turnBasedMatchEntity.getPendingParticipantId(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)8, (int)turnBasedMatchEntity.getStatus());
        zzbfp.zzc((Parcel)parcel2, (int)10, (int)turnBasedMatchEntity.getVariant());
        zzbfp.zzc((Parcel)parcel2, (int)11, (int)turnBasedMatchEntity.getVersion());
        zzbfp.zza((Parcel)parcel2, (int)12, (byte[])turnBasedMatchEntity.getData(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)13, turnBasedMatchEntity.getParticipants(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)14, (String)turnBasedMatchEntity.getRematchId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)15, (byte[])turnBasedMatchEntity.getPreviousMatchData(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)16, (int)turnBasedMatchEntity.getMatchNumber());
        zzbfp.zza((Parcel)parcel2, (int)17, (Bundle)turnBasedMatchEntity.getAutoMatchCriteria(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)18, (int)turnBasedMatchEntity.getTurnStatus());
        zzbfp.zza((Parcel)parcel2, (int)19, (boolean)turnBasedMatchEntity.isLocallyModified());
        zzbfp.zza((Parcel)parcel2, (int)20, (String)turnBasedMatchEntity.getDescription(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)21, (String)turnBasedMatchEntity.getDescriptionParticipantId(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

