/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzhug;
    private final PlayerEntity zzhzq;
    private final byte[] zzhyw;
    private final String zzcrt;
    private final ArrayList<PlayerEntity> zzhzr;
    private final int zzeie;
    private final long mCreationTimestamp;
    private final long zzhzs;
    private final Bundle zzhzt;
    private final int zzcbc;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzhug = new GameEntity(gameRequest.getGame());
        this.zzhzq = new PlayerEntity(gameRequest.getSender());
        this.zzcrt = gameRequest.getRequestId();
        this.zzeie = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzhzs = gameRequest.getExpirationTimestamp();
        this.zzcbc = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzhyw = null;
        } else {
            this.zzhyw = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhyw, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzhzr = new ArrayList(n);
        this.zzhzt = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzhzr.add((PlayerEntity)player);
            this.zzhzt.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzhug = gameEntity;
        this.zzhzq = playerEntity;
        this.zzhyw = byArray;
        this.zzcrt = string;
        this.zzhzr = arrayList;
        this.zzeie = n;
        this.mCreationTimestamp = l;
        this.zzhzs = l2;
        this.zzhzt = bundle;
        this.zzcbc = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzcrt;
    }

    @Override
    public final Game getGame() {
        return this.zzhug;
    }

    @Override
    public final Player getSender() {
        return this.zzhzq;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzhzr);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzhyw;
    }

    @Override
    public final int getType() {
        return this.zzeie;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzhzs;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzhzt.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzcbc;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbg.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbg.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbg.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbg.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbg.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbg.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbg.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbg.zzx((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzbfp.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzhzt, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

