/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;

public final class VideoCapabilities
extends zzc {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new zza();
    private final boolean zzibb;
    private final boolean zzibc;
    private final boolean zzibd;
    private final boolean[] zzibe;
    private final boolean[] zzibf;

    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zzibb = bl;
        this.zzibc = bl2;
        this.zzibd = bl3;
        this.zzibe = blArray;
        this.zzibf = blArray2;
    }

    public final boolean isMicSupported() {
        return this.zzibc;
    }

    public final boolean isCameraSupported() {
        return this.zzibb;
    }

    public final boolean isWriteStorageSupported() {
        return this.zzibd;
    }

    public final boolean[] getSupportedCaptureModes() {
        return this.zzibe;
    }

    public final boolean[] getSupportedQualityLevels() {
        return this.zzibf;
    }

    public final boolean supportsCaptureMode(int n) {
        zzbq.checkState((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzibe[n];
    }

    public final boolean supportsQualityLevel(int n) {
        zzbq.checkState((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzibf[n];
    }

    public final boolean isFullySupported(int n, int n2) {
        return this.zzibb && this.zzibc && this.zzibd && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzbg.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzbg.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzbg.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzbg.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzbg.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public final String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoCapabilities videoCapabilities = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (boolean)videoCapabilities.isCameraSupported());
        zzbfp.zza((Parcel)parcel2, (int)2, (boolean)videoCapabilities.isMicSupported());
        zzbfp.zza((Parcel)parcel2, (int)3, (boolean)videoCapabilities.isWriteStorageSupported());
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean[])videoCapabilities.getSupportedCaptureModes(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (boolean[])videoCapabilities.getSupportedQualityLevels(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

