/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.video.zzb;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class VideoConfiguration
extends zzbfm {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzibg;
    private final int zziaz;
    private final String zzibh;
    private final String zzibi;
    private final String zzibj;
    private final String zzibk;
    private final boolean zzibl;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbq.checkArgument((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbq.checkArgument((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzibg = n;
        this.zziaz = n2;
        this.zzibl = bl;
        if (n2 == 1) {
            this.zzibi = string2;
            this.zzibh = string;
            this.zzibj = string3;
            this.zzibk = string4;
            return;
        }
        zzbq.checkArgument((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbq.checkArgument((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbq.checkArgument((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbq.checkArgument((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzibi = null;
        this.zzibh = null;
        this.zzibj = null;
        this.zzibk = null;
    }

    public final int getQualityLevel() {
        return this.zzibg;
    }

    public final int getCaptureMode() {
        return this.zziaz;
    }

    public final String getStreamUrl() {
        return this.zzibh;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzbfp.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzibi, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzibj, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzibk, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzibl);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzibg;
        private int zziaz;
        private boolean zzibl;
        private String zzibh;
        private String zzibi;
        private String zzibj;
        private String zzibk;

        public Builder(int n, int n2) {
            this.zzibg = n;
            this.zziaz = n2;
            this.zzibl = true;
            this.zzibh = null;
            this.zzibi = null;
            this.zzibj = null;
            this.zzibk = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzibg = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zziaz = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzibg, this.zziaz, null, null, null, null, this.zzibl);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidCaptureModes {
    }
}

