/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.games.AchievementsClient;
import com.google.android.gms.games.EventsClient;
import com.google.android.gms.games.GamesClient;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesMetadataClient;
import com.google.android.gms.games.InvitationsClient;
import com.google.android.gms.games.LeaderboardsClient;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.NotificationsClient;
import com.google.android.gms.games.PlayerStatsClient;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.PlayersClient;
import com.google.android.gms.games.RealTimeMultiplayerClient;
import com.google.android.gms.games.SnapshotsClient;
import com.google.android.gms.games.TurnBasedMultiplayerClient;
import com.google.android.gms.games.VideosClient;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.zzad;
import com.google.android.gms.games.internal.api.zzah;
import com.google.android.gms.games.internal.api.zzax;
import com.google.android.gms.games.internal.api.zzay;
import com.google.android.gms.games.internal.api.zzaz;
import com.google.android.gms.games.internal.api.zzbj;
import com.google.android.gms.games.internal.api.zzbu;
import com.google.android.gms.games.internal.api.zzbv;
import com.google.android.gms.games.internal.api.zzcd;
import com.google.android.gms.games.internal.api.zzcr;
import com.google.android.gms.games.internal.api.zzcs;
import com.google.android.gms.games.internal.api.zzcw;
import com.google.android.gms.games.internal.api.zzdt;
import com.google.android.gms.games.internal.api.zzo;
import com.google.android.gms.games.internal.api.zzq;
import com.google.android.gms.games.internal.api.zzy;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.games.zzi;
import com.google.android.gms.games.zzj;
import com.google.android.gms.games.zzk;
import com.google.android.gms.games.zzl;
import com.google.android.gms.games.zzm;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@KeepForSdk
public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    @Hide
    static final Api.zzf<GamesClientImpl> zza = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzc = new zzi();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzd = new zzj();
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Scope SCOPE_GAMES_LITE = new Scope("https://www.googleapis.com/auth/games_lite");
    @Deprecated
    public static final Api<GamesOptions> API = new Api("Games.API", zzc, zza);
    @Hide
    public static final Scope zzb = new Scope("https://www.googleapis.com/auth/games.firstparty");
    @Hide
    private static Api<GamesOptions> zze = new Api("Games.API_1P", zzd, zza);
    @Deprecated
    public static final GamesMetadata GamesMetadata = new zzy();
    @Deprecated
    public static final Achievements Achievements = new com.google.android.gms.games.internal.api.zza();
    @Hide
    private static zzccr zzf = new zzo();
    @Deprecated
    public static final Events Events = new zzq();
    @Deprecated
    public static final Leaderboards Leaderboards = new zzah();
    @Deprecated
    public static final Invitations Invitations = new zzad();
    @Deprecated
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new zzcw();
    @Deprecated
    public static final RealTimeMultiplayer RealTimeMultiplayer = new zzbu();
    @Hide
    private static Multiplayer zzg = new zzax();
    @Deprecated
    public static final Players Players = new zzaz();
    @Deprecated
    public static final Notifications Notifications = new zzay();
    @Deprecated
    public static final Quests Quests = new zzbj();
    @Deprecated
    public static final Requests Requests = new zzbv();
    @Deprecated
    public static final Snapshots Snapshots = new zzcd();
    @Deprecated
    public static final Stats Stats = new zzcs();
    @Deprecated
    public static final Videos Videos = new zzdt();
    @Hide
    private static zzccz zzh = new zzcr();

    private Games() {
    }

    @Hide
    public static GamesClientImpl zza(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true);
    }

    @Hide
    public static GamesClientImpl zza(GoogleApiClient googleApiClient, boolean bl) {
        zzbq.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzbq.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzb(googleApiClient, bl);
    }

    @Hide
    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzbq.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        if (bl2) {
            return (GamesClientImpl)googleApiClient.zza(zza);
        }
        return null;
    }

    @Deprecated
    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzc(n);
        }
    }

    @Deprecated
    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzbq.zza((Object)view);
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zza(view);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzk();
    }

    @Deprecated
    @Hide
    @KeepForSdk
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, String string) {
        zzbq.zza((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzk(googleApiClient, string));
    }

    @Deprecated
    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzay();
    }

    @Deprecated
    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzau();
    }

    @Deprecated
    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((com.google.android.gms.common.api.internal.zzm)new zzl(googleApiClient));
    }

    @Hide
    private static GamesOptions zza(@NonNull GoogleSignInAccount googleSignInAccount) {
        GoogleSignInAccount googleSignInAccount2;
        GoogleSignInAccount googleSignInAccount3 = googleSignInAccount2 = googleSignInAccount;
        GamesOptions.Builder builder = new GamesOptions.Builder(null, null);
        new GamesOptions.Builder(null, null).zza = googleSignInAccount3;
        return builder.setSdkVariant(0x101113).build();
    }

    public static GamesMetadataClient getGamesMetadataClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesMetadataClient(activity, Games.zza(googleSignInAccount));
    }

    public static GamesMetadataClient getGamesMetadataClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesMetadataClient(context, Games.zza(googleSignInAccount));
    }

    public static AchievementsClient getAchievementsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new AchievementsClient(activity, Games.zza(googleSignInAccount));
    }

    public static AchievementsClient getAchievementsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new AchievementsClient(context, Games.zza(googleSignInAccount));
    }

    public static EventsClient getEventsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new EventsClient(activity, Games.zza(googleSignInAccount));
    }

    public static EventsClient getEventsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new EventsClient(context, Games.zza(googleSignInAccount));
    }

    public static LeaderboardsClient getLeaderboardsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new LeaderboardsClient(activity, Games.zza(googleSignInAccount));
    }

    public static LeaderboardsClient getLeaderboardsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new LeaderboardsClient(context, Games.zza(googleSignInAccount));
    }

    public static InvitationsClient getInvitationsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new InvitationsClient(activity, Games.zza(googleSignInAccount));
    }

    public static InvitationsClient getInvitationsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new InvitationsClient(context, Games.zza(googleSignInAccount));
    }

    public static TurnBasedMultiplayerClient getTurnBasedMultiplayerClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new TurnBasedMultiplayerClient(activity, Games.zza(googleSignInAccount));
    }

    public static TurnBasedMultiplayerClient getTurnBasedMultiplayerClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new TurnBasedMultiplayerClient(context, Games.zza(googleSignInAccount));
    }

    public static RealTimeMultiplayerClient getRealTimeMultiplayerClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new RealTimeMultiplayerClient(activity, Games.zza(googleSignInAccount));
    }

    public static RealTimeMultiplayerClient getRealTimeMultiplayerClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new RealTimeMultiplayerClient(context, Games.zza(googleSignInAccount));
    }

    public static PlayersClient getPlayersClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayersClient(activity, Games.zza(googleSignInAccount));
    }

    public static PlayersClient getPlayersClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayersClient(context, Games.zza(googleSignInAccount));
    }

    public static NotificationsClient getNotificationsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new NotificationsClient(activity, Games.zza(googleSignInAccount));
    }

    public static NotificationsClient getNotificationsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new NotificationsClient(context, Games.zza(googleSignInAccount));
    }

    public static SnapshotsClient getSnapshotsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new SnapshotsClient(activity, Games.zza(googleSignInAccount));
    }

    public static SnapshotsClient getSnapshotsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new SnapshotsClient(context, Games.zza(googleSignInAccount));
    }

    public static PlayerStatsClient getPlayerStatsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayerStatsClient(activity, Games.zza(googleSignInAccount));
    }

    public static PlayerStatsClient getPlayerStatsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayerStatsClient(context, Games.zza(googleSignInAccount));
    }

    public static VideosClient getVideosClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new VideosClient(activity, Games.zza(googleSignInAccount));
    }

    public static VideosClient getVideosClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new VideosClient(context, Games.zza(googleSignInAccount));
    }

    public static GamesClient getGamesClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesClient(activity, Games.zza(googleSignInAccount));
    }

    public static GamesClient getGamesClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.zza((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesClient(context, Games.zza(googleSignInAccount));
    }

    @Deprecated
    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzaw();
    }

    static abstract class zzd
    extends zza<Status> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zza(Status status) {
            return status;
        }

        /* synthetic */ zzd(GoogleApiClient googleApiClient, zzi zzi2) {
            this(googleApiClient);
        }
    }

    static abstract class zzc
    extends zza<GetServerAuthCodeResult> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zza(Status status) {
            Status status2 = status;
            zzc zzc2 = this;
            return new zzm(zzc2, status2);
        }

        /* synthetic */ zzc(GoogleApiClient googleApiClient, zzi zzi2) {
            this(googleApiClient);
        }
    }

    @Deprecated
    @Hide
    @KeepForSdk
    public static interface GetServerAuthCodeResult
    extends Result {
        @KeepForSdk
        public String getCode();
    }

    @Hide
    public static abstract class zza<R extends Result>
    extends com.google.android.gms.common.api.internal.zzm<R, GamesClientImpl> {
        public zza(GoogleApiClient googleApiClient) {
            super(zza, googleApiClient);
        }
    }

    static abstract class zzb
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private zzb() {
        }

        public final int zza() {
            return 1;
        }

        public final /* synthetic */ Api.zze zza(Context context, Looper looper, zzr zzr2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
            GamesOptions gamesOptions = (GamesOptions)object;
            zzr zzr3 = zzr2;
            Looper looper2 = looper;
            Context context2 = context;
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions.Builder(null).build();
            }
            return new GamesClientImpl(context2, looper2, zzr3, gamesOptions, connectionCallbacks2, onConnectionFailedListener2);
        }

        /* synthetic */ zzb(zzi zzi2) {
            this();
        }
    }

    @Deprecated
    public static final class GamesOptions
    implements GoogleSignInOptionsExtension,
    Api.ApiOptions.HasGoogleSignInAccountOptions,
    Api.ApiOptions.Optional {
        @Hide
        public final boolean zza;
        @Hide
        public final boolean zzb;
        @Hide
        public final int zzc;
        @Hide
        public final boolean zzd;
        @Hide
        public final int zze;
        @Hide
        public final String zzf;
        @Hide
        public final ArrayList<String> zzg;
        @Hide
        public final boolean zzh;
        @Hide
        public final boolean zzi;
        @Hide
        public final boolean zzj;
        @Hide
        public final GoogleSignInAccount zzk;

        private GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList<String> arrayList, boolean bl4, boolean bl5, boolean bl6, GoogleSignInAccount googleSignInAccount) {
            this.zza = bl;
            this.zzb = bl2;
            this.zzc = n;
            this.zzd = bl3;
            this.zze = n2;
            this.zzf = string;
            this.zzg = arrayList;
            this.zzh = bl4;
            this.zzi = bl5;
            this.zzj = bl6;
            this.zzk = googleSignInAccount;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof GamesOptions)) {
                return false;
            }
            GamesOptions gamesOptions = (GamesOptions)object;
            return this.zza == gamesOptions.zza && this.zzb == gamesOptions.zzb && this.zzc == gamesOptions.zzc && this.zzd == gamesOptions.zzd && this.zze == gamesOptions.zze && (this.zzf == null ? gamesOptions.zzf == null : this.zzf.equals(gamesOptions.zzf)) && this.zzg.equals(gamesOptions.zzg) && this.zzh == gamesOptions.zzh && this.zzi == gamesOptions.zzi && this.zzj == gamesOptions.zzj && (this.zzk == null ? gamesOptions.zzk == null : this.zzk.equals((Object)gamesOptions.zzk));
        }

        public final int hashCode() {
            int n = 527 + (this.zza ? 1 : 0);
            n = n * 31 + (this.zzb ? 1 : 0);
            n = n * 31 + this.zzc;
            n = n * 31 + (this.zzd ? 1 : 0);
            n = n * 31 + this.zze;
            n = n * 31 + (this.zzf == null ? 0 : this.zzf.hashCode());
            n = n * 31 + this.zzg.hashCode();
            n = n * 31 + (this.zzh ? 1 : 0);
            n = n * 31 + (this.zzi ? 1 : 0);
            n = n * 31 + (this.zzj ? 1 : 0);
            return n * 31 + (this.zzk == null ? 0 : this.zzk.hashCode());
        }

        @Hide
        public final int getExtensionType() {
            return 1;
        }

        @Hide
        public final List<Scope> getImpliedScopes() {
            if (this.zzh) {
                return Collections.singletonList(SCOPE_GAMES);
            }
            return Collections.singletonList(SCOPE_GAMES_LITE);
        }

        @Hide
        public final Bundle toBundle() {
            return this.zza();
        }

        @Hide
        public final Bundle zza() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zza);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzb);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzc);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzd);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zze);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzf);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzg);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.zzh);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", this.zzi);
            bundle.putBoolean("com.google.android.gms.games.key.skipWelcomePopup", this.zzj);
            return bundle;
        }

        public static Builder builder() {
            return new Builder(null);
        }

        @Hide
        public final GoogleSignInAccount getGoogleSignInAccount() {
            return this.zzk;
        }

        /* synthetic */ GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList arrayList, boolean bl4, boolean bl5, boolean bl6, GoogleSignInAccount googleSignInAccount, zzi zzi2) {
            this(bl, bl2, n, bl3, n2, string, arrayList, bl4, bl5, bl6, googleSignInAccount);
        }

        @Deprecated
        public static final class Builder {
            private boolean zzb = false;
            private boolean zzc = true;
            private int zzd = 17;
            private boolean zze = false;
            private int zzf = 4368;
            private String zzg = null;
            private ArrayList<String> zzh = new ArrayList();
            private boolean zzi = false;
            private boolean zzj = false;
            private boolean zzk = false;
            GoogleSignInAccount zza = null;

            private Builder() {
            }

            private Builder(GamesOptions gamesOptions) {
                if (gamesOptions != null) {
                    this.zzb = gamesOptions.zza;
                    this.zzc = gamesOptions.zzb;
                    this.zzd = gamesOptions.zzc;
                    this.zze = gamesOptions.zzd;
                    this.zzf = gamesOptions.zze;
                    this.zzg = gamesOptions.zzf;
                    this.zzh = gamesOptions.zzg;
                    this.zzi = gamesOptions.zzh;
                    this.zzj = gamesOptions.zzi;
                    this.zzk = gamesOptions.zzj;
                    this.zza = gamesOptions.zzk;
                }
            }

            public final Builder setShowConnectingPopup(boolean bl) {
                this.zzc = bl;
                this.zzd = 17;
                return this;
            }

            public final Builder setShowConnectingPopup(boolean bl, int n) {
                this.zzc = bl;
                this.zzd = n;
                return this;
            }

            public final Builder setSdkVariant(int n) {
                this.zzf = n;
                return this;
            }

            public final GamesOptions build() {
                return new GamesOptions(this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zza, null);
            }

            /* synthetic */ Builder(zzi zzi2) {
                this();
            }

            /* synthetic */ Builder(GamesOptions gamesOptions, zzi zzi2) {
                this((GamesOptions)null);
            }
        }
    }
}

