/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzap;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zza;
    private String zzb;
    private final Uri zzc;
    private final Uri zzd;
    private final long zze;
    private final int zzf;
    private final long zzg;
    private final String zzh;
    private final String zzi;
    private final String zzj;
    private final zzb zzk;
    private final PlayerLevelInfo zzl;
    private final boolean zzm;
    private final boolean zzn;
    private final String zzo;
    private final String zzp;
    private final Uri zzq;
    private final String zzr;
    private final Uri zzs;
    private final String zzt;
    private final int zzu;
    private final long zzv;
    private final boolean zzw;

    @Hide
    public PlayerEntity(Player player) {
        this(player, true);
    }

    @Hide
    private PlayerEntity(Player player, boolean bl) {
        this.zza = player.getPlayerId();
        this.zzb = player.getDisplayName();
        this.zzc = player.getIconImageUri();
        this.zzh = player.getIconImageUrl();
        this.zzd = player.getHiResImageUri();
        this.zzi = player.getHiResImageUrl();
        this.zze = player.getRetrievedTimestamp();
        this.zzf = player.zzd();
        this.zzg = player.getLastPlayedWithTimestamp();
        this.zzj = player.getTitle();
        this.zzm = player.zze();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzf();
        this.zzk = zza2 == null ? null : new zzb(zza2);
        this.zzl = player.getLevelInfo();
        this.zzn = player.zzc();
        this.zzo = player.zza();
        this.zzp = player.zzb();
        this.zzq = player.getBannerImageLandscapeUri();
        this.zzr = player.getBannerImageLandscapeUrl();
        this.zzs = player.getBannerImagePortraitUri();
        this.zzt = player.getBannerImagePortraitUrl();
        this.zzu = player.zzg();
        this.zzv = player.zzh();
        this.zzw = player.zzi();
        com.google.android.gms.common.internal.zzc.zza((Object)this.zza);
        com.google.android.gms.common.internal.zzc.zza((Object)this.zzb);
        com.google.android.gms.common.internal.zzc.zza((this.zze > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = uri;
        this.zzh = string3;
        this.zzd = uri2;
        this.zzi = string4;
        this.zze = l;
        this.zzf = n;
        this.zzg = l2;
        this.zzj = string5;
        this.zzm = bl;
        this.zzk = zzb2;
        this.zzl = playerLevelInfo;
        this.zzn = bl2;
        this.zzo = string6;
        this.zzp = string7;
        this.zzq = uri3;
        this.zzr = string8;
        this.zzs = uri4;
        this.zzt = string9;
        this.zzu = n2;
        this.zzv = l3;
        this.zzw = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zza;
    }

    @Override
    public final String getDisplayName() {
        return this.zzb;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    @Hide
    public final String zza() {
        return this.zzo;
    }

    @Override
    @Hide
    public final String zzb() {
        return this.zzp;
    }

    @Override
    @Hide
    public final boolean zzc() {
        return this.zzn;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzc;
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        return this.zzh;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzd;
    }

    @Override
    @Hide
    public final String getHiResImageUrl() {
        return this.zzi;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zze;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzg;
    }

    @Override
    @Hide
    public final int zzd() {
        return this.zzf;
    }

    @Override
    @Hide
    public final boolean zze() {
        return this.zzm;
    }

    @Override
    public final String getTitle() {
        return this.zzj;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzj, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzl;
    }

    @Override
    @Hide
    public final com.google.android.gms.games.internal.player.zza zzf() {
        return this.zzk;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzq;
    }

    @Override
    @Hide
    public final String getBannerImageLandscapeUrl() {
        return this.zzr;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzs;
    }

    @Override
    @Hide
    public final String getBannerImagePortraitUrl() {
        return this.zzt;
    }

    @Override
    @Hide
    public final int zzg() {
        return this.zzu;
    }

    @Override
    @Hide
    public final long zzh() {
        return this.zzv;
    }

    @Override
    @Hide
    public final boolean zzi() {
        return this.zzw;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzc(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zza(), player.zzb(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzg(), player.zzh(), player.zzi()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbg.zza((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbg.zza((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbg.zza((Object)player2.zzc(), (Object)player.zzc()) && zzbg.zza((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbg.zza((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbg.zza((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbg.zza((Object)player2.getTitle(), (Object)player.getTitle()) && zzbg.zza((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbg.zza((Object)player2.zza(), (Object)player.zza()) && zzbg.zza((Object)player2.zzb(), (Object)player.zzb()) && zzbg.zza((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbg.zza((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbg.zza((Object)player2.zzg(), (Object)player.zzg()) && zzbg.zza((Object)player2.zzh(), (Object)player.zzh()) && zzbg.zza((Object)player2.zzi(), (Object)player.zzi());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbg.zza((Object)player).zza("PlayerId", (Object)player.getPlayerId()).zza("DisplayName", (Object)player.getDisplayName()).zza("HasDebugAccess", (Object)player.zzc()).zza("IconImageUri", (Object)player.getIconImageUri()).zza("IconImageUrl", (Object)player.getIconImageUrl()).zza("HiResImageUri", (Object)player.getHiResImageUri()).zza("HiResImageUrl", (Object)player.getHiResImageUrl()).zza("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zza("Title", (Object)player.getTitle()).zza("LevelInfo", (Object)player.getLevelInfo()).zza("GamerTag", (Object)player.zza()).zza("Name", (Object)player.zzb()).zza("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zza("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zza("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zza("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zza("GamerFriendStatus", (Object)player.zzg()).zza("GamerFriendUpdateTimestamp", (Object)player.zzh()).zza("IsMuted", (Object)player.zzi()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)6, (int)playerEntity.zzf);
        zzbgo.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzk, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzm);
        zzbgo.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzn);
        zzbgo.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzo, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)21, (String)playerEntity.zzp, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)26, (int)playerEntity.zzu);
        zzbgo.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzv);
        zzbgo.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzw);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzap {
        zza() {
        }

        @Override
        public final PlayerEntity zza(Parcel parcel) {
            if (PlayerEntity.zzb(PlayerEntity.o_()) || PlayerEntity.zza((String)PlayerEntity.class.getCanonicalName())) {
                return super.zza(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzap)this).zza(parcel);
        }
    }
}

