/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.GamesClientStatusCodes;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.internal.zzh;
import com.google.android.gms.games.internal.zzi;
import com.google.android.gms.games.internal.zzj;
import com.google.android.gms.games.internal.zzk;
import com.google.android.gms.games.internal.zzl;
import com.google.android.gms.games.internal.zzm;
import com.google.android.gms.games.internal.zzn;
import com.google.android.gms.games.internal.zzo;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.TimeUnit;

public final class zzg {
    private static zzp zza = zzm.zza;

    public static <R, PendingR extends Result, ExceptionData> Task<R> zza(@NonNull PendingResult<PendingR> pendingResult, @NonNull zzp zzp2, @NonNull zzbo<PendingR, R> zzbo2, @NonNull zzbo<PendingR, ExceptionData> zzbo3, @NonNull zzn<ExceptionData> zzn2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        pendingResult.zza((PendingResult.zza)new zzh(pendingResult, zzp2, taskCompletionSource, zzbo2, zzbo3, zzn2));
        return taskCompletionSource.getTask();
    }

    public static <R, PendingR extends Result> Task<R> zza(@NonNull PendingResult<PendingR> pendingResult, @NonNull zzbo<PendingR, R> zzbo2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        pendingResult.zza((PendingResult.zza)new zzi(pendingResult, taskCompletionSource, zzbo2));
        return taskCompletionSource.getTask();
    }

    public static <R, PendingR extends Result> Task<AnnotatedData<R>> zza(@NonNull PendingResult<PendingR> pendingResult, @NonNull zzbo<PendingR, R> zzbo2, @Nullable zzo<PendingR> zzo2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        pendingResult.zza((PendingResult.zza)new zzj(pendingResult, taskCompletionSource, zzbo2, zzo2));
        return taskCompletionSource.getTask();
    }

    public static <R, PendingR extends Result> Task<AnnotatedData<R>> zzb(@NonNull PendingResult<PendingR> pendingResult, @NonNull zzbo<PendingR, R> zzbo2) {
        return zzg.zza(pendingResult, zzbo2, null);
    }

    public static <R extends Releasable, PendingR extends Result> Task<AnnotatedData<R>> zzc(@NonNull PendingResult<PendingR> pendingResult, @NonNull zzbo<PendingR, R> zzbo2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        pendingResult.zza((PendingResult.zza)new zzk(zzbo2, pendingResult, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    public static <R, PendingR extends Result> Task<R> zza(@NonNull PendingResult<PendingR> pendingResult, @NonNull zzp zzp2, @NonNull zzbo<PendingR, R> zzbo2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        pendingResult.zza((PendingResult.zza)new zzl(zzp2, pendingResult, taskCompletionSource, zzbo2));
        return taskCompletionSource.getTask();
    }

    private static Status zza(@NonNull Status status) {
        int n = GamesClientStatusCodes.zzb(status.getStatusCode());
        if (n != status.getStatusCode()) {
            if (GamesStatusCodes.getStatusString(status.getStatusCode()).equals(status.getStatusMessage())) {
                return GamesClientStatusCodes.zza(n);
            }
            return new Status(n, status.getStatusMessage());
        }
        return status;
    }

    static final /* synthetic */ void zza(zzp zzp2, PendingResult pendingResult, TaskCompletionSource taskCompletionSource, zzbo zzbo2, Status status) {
        if (zzp2.zza(status)) {
            Result result = pendingResult.await(0L, TimeUnit.MILLISECONDS);
            taskCompletionSource.setResult(zzbo2.zza(result));
            return;
        }
        taskCompletionSource.setException((Exception)zzb.zza((Status)zzg.zza(status)));
    }

    static final /* synthetic */ void zza(zzbo zzbo2, PendingResult pendingResult, TaskCompletionSource taskCompletionSource, Status status) {
        boolean bl = status.getStatusCode() == 3;
        Releasable releasable = (Releasable)zzbo2.zza(pendingResult.await(0L, TimeUnit.MILLISECONDS));
        if (status.isSuccess() || bl) {
            taskCompletionSource.setResult(new AnnotatedData<Releasable>(releasable, bl));
            return;
        }
        if (releasable != null) {
            releasable.release();
        }
        taskCompletionSource.setException((Exception)zzb.zza((Status)zzg.zza(status)));
    }

    static final /* synthetic */ void zza(PendingResult pendingResult, TaskCompletionSource taskCompletionSource, zzbo zzbo2, zzo zzo2, Status status) {
        boolean bl = status.getStatusCode() == 3;
        Result result = pendingResult.await(0L, TimeUnit.MILLISECONDS);
        if (status.isSuccess() || bl) {
            taskCompletionSource.setResult(new AnnotatedData<Object>(zzbo2.zza(result), bl));
            return;
        }
        if (result != null && zzo2 != null) {
            zzo2.zza(result);
        }
        taskCompletionSource.setException((Exception)zzb.zza((Status)zzg.zza(status)));
    }

    static final /* synthetic */ void zza(PendingResult pendingResult, TaskCompletionSource taskCompletionSource, zzbo zzbo2, Status status) {
        Result result = pendingResult.await(0L, TimeUnit.MILLISECONDS);
        if (status.isSuccess()) {
            taskCompletionSource.setResult(zzbo2.zza(result));
            return;
        }
        taskCompletionSource.setException((Exception)zzb.zza((Status)zzg.zza(status)));
    }

    static final /* synthetic */ void zza(PendingResult pendingResult, zzp zzp2, TaskCompletionSource taskCompletionSource, zzbo zzbo2, zzbo zzbo3, zzn zzn2, Status status) {
        Result result = pendingResult.await(0L, TimeUnit.MILLISECONDS);
        if (zzp2.zza(status)) {
            taskCompletionSource.setResult(zzbo2.zza(result));
            return;
        }
        Object object = zzbo3.zza(result);
        if (object != null) {
            taskCompletionSource.setException((Exception)zzn2.zza(zzg.zza(status), object));
            return;
        }
        taskCompletionSource.setException((Exception)zzb.zza((Status)zzg.zza(status)));
    }
}

