/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zza;
    private final String zzb;
    private final Uri zzc;
    private final Uri zzd;
    private final int zze;
    private final String zzf;
    private final boolean zzg;
    private final PlayerEntity zzh;
    private final int zzi;
    private final ParticipantResult zzj;
    private final String zzk;
    private final String zzl;

    @Hide
    public ParticipantEntity(Participant participant) {
        this.zza = participant.getParticipantId();
        this.zzb = participant.getDisplayName();
        this.zzc = participant.getIconImageUri();
        this.zzd = participant.getHiResImageUri();
        this.zze = participant.getStatus();
        this.zzf = participant.zza();
        this.zzg = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzh = player == null ? null : new PlayerEntity(player);
        this.zzi = participant.zzb();
        this.zzj = participant.getResult();
        this.zzk = participant.getIconImageUrl();
        this.zzl = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = uri;
        this.zzd = uri2;
        this.zze = n;
        this.zzf = string3;
        this.zzg = bl;
        this.zzh = playerEntity;
        this.zzi = n2;
        this.zzj = participantResult;
        this.zzk = string4;
        this.zzl = string5;
    }

    @Override
    public final int getStatus() {
        return this.zze;
    }

    @Override
    @Hide
    public final String zza() {
        return this.zzf;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzg;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzh == null) {
            return this.zzb;
        }
        return this.zzh.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzh == null) {
            com.google.android.gms.common.util.zzh.zza((String)this.zzb, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzh.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzh == null) {
            return this.zzc;
        }
        return this.zzh.getIconImageUri();
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        if (this.zzh == null) {
            return this.zzk;
        }
        return this.zzh.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzh == null) {
            return this.zzd;
        }
        return this.zzh.getHiResImageUri();
    }

    @Override
    @Hide
    public final String getHiResImageUrl() {
        if (this.zzh == null) {
            return this.zzl;
        }
        return this.zzh.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zza;
    }

    @Override
    public final Player getPlayer() {
        return this.zzh;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzj;
    }

    @Override
    @Hide
    public final int zzb() {
        return this.zzi;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zza(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.zzb(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbg.zza((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbg.zza((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbg.zza((Object)participant2.zza(), (Object)participant.zza()) && zzbg.zza((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbg.zza((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbg.zza((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbg.zza((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbg.zza((Object)participant2.zzb(), (Object)participant.zzb()) && zzbg.zza((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbg.zza((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbg.zza((Object)participant).zza("ParticipantId", (Object)participant.getParticipantId()).zza("Player", (Object)participant.getPlayer()).zza("Status", (Object)participant.getStatus()).zza("ClientAddress", (Object)participant.zza()).zza("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zza("DisplayName", (Object)participant.getDisplayName()).zza("IconImage", (Object)participant.getIconImageUri()).zza("IconImageUrl", (Object)participant.getIconImageUrl()).zza("HiResImage", (Object)participant.getHiResImageUri()).zza("HiResImageUrl", (Object)participant.getHiResImageUrl()).zza("Capabilities", (Object)participant.zzb()).zza("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzbgo.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzf, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (int)participantEntity.zzi);
        zzbgo.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zza(Parcel parcel) {
            if (ParticipantEntity.zzb(ParticipantEntity.o_()) || ParticipantEntity.zza((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zza(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzc)this).zza(parcel);
        }
    }
}

