/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

@Hide
public final class ParticipantRef
extends zzc
implements Participant {
    private final PlayerRef zzc;

    @Hide
    public ParticipantRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzc = new PlayerRef(dataHolder, n);
    }

    @Override
    public final int getStatus() {
        return this.zzc("player_status");
    }

    @Override
    @Hide
    public final String zza() {
        return this.zze("client_address");
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzc("connected") > 0;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzi("external_player_id")) {
            return this.zze("default_display_name");
        }
        return this.zzc.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzi("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.zzc.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzi("external_player_id")) {
            return this.zzh("default_display_image_uri");
        }
        return this.zzc.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzi("external_player_id")) {
            return this.zze("default_display_image_url");
        }
        return this.zzc.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzi("external_player_id")) {
            return this.zzh("default_display_hi_res_image_uri");
        }
        return this.zzc.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzi("external_player_id")) {
            return this.zze("default_display_hi_res_image_url");
        }
        return this.zzc.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zze("external_participant_id");
    }

    @Override
    public final Player getPlayer() {
        if (this.zzi("external_player_id")) {
            return null;
        }
        return this.zzc;
    }

    @Override
    public final ParticipantResult getResult() {
        if (this.zzi("result_type")) {
            return null;
        }
        int n = this.zzc("result_type");
        int n2 = this.zzc("placing");
        return new ParticipantResult(this.getParticipantId(), n, n2);
    }

    @Override
    @Hide
    public final int zzb() {
        return this.zzc("capabilities");
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((ParticipantEntity)((Participant)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        ParticipantRef participantRef = this;
        return new ParticipantEntity(participantRef);
    }
}

