/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

@Hide
public final class SnapshotMetadataRef
extends zzc
implements SnapshotMetadata {
    private final Game zzc;
    private final Player zzd;

    @Hide
    public SnapshotMetadataRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzc = new GameRef(dataHolder, n);
        this.zzd = new PlayerRef(dataHolder, n);
    }

    @Override
    public final Game getGame() {
        return this.zzc;
    }

    @Override
    public final Player getOwner() {
        return this.zzd;
    }

    @Override
    public final String getSnapshotId() {
        return this.zze("external_snapshot_id");
    }

    @Override
    public final Uri getCoverImageUri() {
        return this.zzh("cover_icon_image_uri");
    }

    @Override
    public final String getCoverImageUrl() {
        return this.zze("cover_icon_image_url");
    }

    @Override
    public final float getCoverImageAspectRatio() {
        float f = this.zzf("cover_icon_image_height");
        float f2 = this.zzf("cover_icon_image_width");
        if (f == 0.0f) {
            return 0.0f;
        }
        return f2 / f;
    }

    @Override
    public final String getUniqueName() {
        return this.zze("unique_name");
    }

    @Override
    public final String zza() {
        return this.zze("title");
    }

    @Override
    public final String getDescription() {
        return this.zze("description");
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public final long getLastModifiedTimestamp() {
        return this.zzb("last_modified_timestamp");
    }

    @Override
    public final long getPlayedTime() {
        return this.zzb("duration");
    }

    @Override
    public final boolean hasChangePending() {
        return this.zzc("pending_change_count") > 0;
    }

    @Override
    public final long getProgressValue() {
        return this.zzb("progress_value");
    }

    @Override
    public final String getDeviceName() {
        return this.zze("device_name");
    }

    public final int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return SnapshotMetadataEntity.zza(this, object);
    }

    public final String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((SnapshotMetadataEntity)((SnapshotMetadata)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        SnapshotMetadataRef snapshotMetadataRef = this;
        return new SnapshotMetadataEntity(snapshotMetadataRef);
    }
}

