/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract zza zzpc();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzZO;
        private Long zzakE;
        private Long zzakF;
        private zza zzakG;
        private Uri zzakH;

        public Builder setDescription(String description) {
            this.zzZO = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzakE = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzakF = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzakG = new zza(coverImage);
            this.zzakH = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzZO = metadata.getDescription();
            this.zzakE = metadata.getPlayedTime();
            this.zzakF = metadata.getProgressValue();
            if (this.zzakE == -1L) {
                this.zzakE = null;
            }
            this.zzakH = metadata.getCoverImageUri();
            if (this.zzakH != null) {
                this.zzakG = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzZO, this.zzakE, this.zzakG, this.zzakH, this.zzakF);
        }
    }
}

