/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zzlw;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final AchievementEntityCreator CREATOR = new AchievementEntityCreator();
    private final int zzFG;
    private final String zzacY;
    private final int zzJp;
    private final String mName;
    private final String zzZO;
    private final Uri zzacZ;
    private final String zzada;
    private final Uri zzadb;
    private final String zzadc;
    private final int zzadd;
    private final String zzade;
    private final PlayerEntity zzadf;
    private final int mState;
    private final int zzadg;
    private final String zzadh;
    private final long zzadi;
    private final long zzadj;

    public AchievementEntity(Achievement achievement) {
        this.zzFG = 1;
        this.zzacY = achievement.getAchievementId();
        this.zzJp = achievement.getType();
        this.mName = achievement.getName();
        this.zzZO = achievement.getDescription();
        this.zzacZ = achievement.getUnlockedImageUri();
        this.zzada = achievement.getUnlockedImageUrl();
        this.zzadb = achievement.getRevealedImageUri();
        this.zzadc = achievement.getRevealedImageUrl();
        this.zzadf = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzadi = achievement.getLastUpdatedTimestamp();
        this.zzadj = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzadd = achievement.getTotalSteps();
            this.zzade = achievement.getFormattedTotalSteps();
            this.zzadg = achievement.getCurrentSteps();
            this.zzadh = achievement.getFormattedCurrentSteps();
        } else {
            this.zzadd = 0;
            this.zzade = null;
            this.zzadg = 0;
            this.zzadh = null;
        }
        zzb.zzh((Object)this.zzacY);
        zzb.zzh((Object)this.zzZO);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.zzFG = versionCode;
        this.zzacY = achievementId;
        this.zzJp = type;
        this.mName = name;
        this.zzZO = description;
        this.zzacZ = unlockedImageUri;
        this.zzada = unlockedImageUrl;
        this.zzadb = revealedImageUri;
        this.zzadc = revealedImageUrl;
        this.zzadd = totalSteps;
        this.zzade = formattedTotalSteps;
        this.zzadf = player;
        this.mState = state;
        this.zzadg = currentSteps;
        this.zzadh = formattedCurrentSteps;
        this.zzadi = lastUpdatedTimestamp;
        this.zzadj = xpValue;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getAchievementId() {
        return this.zzacY;
    }

    @Override
    public int getType() {
        return this.zzJp;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzacZ;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzada;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzadb;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzadc;
    }

    @Override
    public int getTotalSteps() {
        return this.zzadd;
    }

    @Override
    public String getFormattedTotalSteps() {
        return this.zzade;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzade, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzadf;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        return this.zzadg;
    }

    @Override
    public String getFormattedCurrentSteps() {
        return this.zzadh;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzadh, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzadi;
    }

    @Override
    public long getXpValue() {
        return this.zzadj;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzw.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzw.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzw.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzw.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzw.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzw.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzw.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzw.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzw.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzw.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzw.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzw.zza zza2 = zzw.zzk((Object)achievement).zza("Id", (Object)achievement.getAchievementId()).zza("Type", (Object)achievement.getType()).zza("Name", (Object)achievement.getName()).zza("Description", (Object)achievement.getDescription()).zza("Player", (Object)achievement.getPlayer()).zza("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zza("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zza("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

