/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int zzFG;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzadu;
    private final ArrayList<AppContentConditionEntity> zzadk;
    private final String zzadl;
    private final int zzadv;
    private final String zzZO;
    private final Bundle mExtras;
    private final String zzadw;
    private final String zzSy;
    private final int zzadx;
    private final String zzxV;
    private final String zzFA;

    public AppContentCardEntity(AppContentCard card) {
        this.zzFG = 4;
        this.zzadl = card.zzmJ();
        this.zzadv = card.zzmU();
        this.zzZO = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzFA = card.getId();
        this.zzSy = card.getTitle();
        this.zzadw = card.zzmV();
        this.zzadx = card.zzmW();
        this.zzxV = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zzmT();
        int n2 = list2.size();
        this.zzadu = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzadu.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zzmI();
        int n3 = list3.size();
        this.zzadk = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzadk.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.zzFG = versionCode;
        this.mActions = actions;
        this.zzadu = annotations;
        this.zzadk = conditions;
        this.zzadl = contentDescription;
        this.zzadv = currentProgress;
        this.zzZO = description;
        this.mExtras = extras;
        this.zzFA = id;
        this.zzadw = subtitle;
        this.zzSy = title;
        this.zzadx = totalProgress;
        this.zzxV = type;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzmT() {
        return new ArrayList<AppContentAnnotation>(this.zzadu);
    }

    @Override
    public List<AppContentCondition> zzmI() {
        return new ArrayList<AppContentCondition>(this.zzadk);
    }

    @Override
    public String zzmJ() {
        return this.zzadl;
    }

    @Override
    public int zzmU() {
        return this.zzadv;
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzFA;
    }

    @Override
    public String zzmV() {
        return this.zzadw;
    }

    @Override
    public String getTitle() {
        return this.zzSy;
    }

    @Override
    public int zzmW() {
        return this.zzadx;
    }

    @Override
    public String getType() {
        return this.zzxV;
    }

    public AppContentCard zzmX() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzw.hashCode((Object[])new Object[]{appContentCard.getActions(), appContentCard.zzmT(), appContentCard.zzmI(), appContentCard.zzmJ(), appContentCard.zzmU(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zzmV(), appContentCard.getTitle(), appContentCard.zzmW(), appContentCard.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzw.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzw.equal(appContentCard2.zzmT(), appContentCard.zzmT()) && zzw.equal(appContentCard2.zzmI(), appContentCard.zzmI()) && zzw.equal((Object)appContentCard2.zzmJ(), (Object)appContentCard.zzmJ()) && zzw.equal((Object)appContentCard2.zzmU(), (Object)appContentCard.zzmU()) && zzw.equal((Object)appContentCard2.getDescription(), (Object)appContentCard.getDescription()) && zzw.equal((Object)appContentCard2.getExtras(), (Object)appContentCard.getExtras()) && zzw.equal((Object)appContentCard2.getId(), (Object)appContentCard.getId()) && zzw.equal((Object)appContentCard2.zzmV(), (Object)appContentCard.zzmV()) && zzw.equal((Object)appContentCard2.getTitle(), (Object)appContentCard.getTitle()) && zzw.equal((Object)appContentCard2.zzmW(), (Object)appContentCard.zzmW()) && zzw.equal((Object)appContentCard2.getType(), (Object)appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzw.zzk((Object)appContentCard).zza("Actions", appContentCard.getActions()).zza("Annotations", appContentCard.zzmT()).zza("Conditions", appContentCard.zzmI()).zza("ContentDescription", (Object)appContentCard.zzmJ()).zza("CurrentSteps", (Object)appContentCard.zzmU()).zza("Description", (Object)appContentCard.getDescription()).zza("Extras", (Object)appContentCard.getExtras()).zza("Id", (Object)appContentCard.getId()).zza("Subtitle", (Object)appContentCard.zzmV()).zza("Title", (Object)appContentCard.getTitle()).zza("TotalSteps", (Object)appContentCard.zzmW()).zza("Type", (Object)appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzmX();
    }
}

