/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.zzlw;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzaiR;
    private final String zzSJ;
    private final Uri zzacc;
    private final int zzaiS;
    private final ArrayList<LeaderboardVariantEntity> zzaiT;
    private final Game zzaiU;
    private final String zzacn;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzaiR = leaderboard.getLeaderboardId();
        this.zzSJ = leaderboard.getDisplayName();
        this.zzacc = leaderboard.getIconImageUri();
        this.zzacn = leaderboard.getIconImageUrl();
        this.zzaiS = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzaiU = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzaiT = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaiT.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzaiR;
    }

    @Override
    public String getDisplayName() {
        return this.zzSJ;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzSJ, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzacc;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzacn;
    }

    @Override
    public int getScoreOrder() {
        return this.zzaiS;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzaiT);
    }

    @Override
    public Game getGame() {
        return this.zzaiU;
    }

    public Leaderboard zzoP() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzw.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.zza(this, obj);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzw.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzw.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzw.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzw.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzw.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzw.zzk((Object)leaderboard).zza("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zza("DisplayName", (Object)leaderboard.getDisplayName()).zza("IconImageUri", (Object)leaderboard.getIconImageUri()).zza("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zza("ScoreOrder", (Object)leaderboard.getScoreOrder()).zza("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzoP();
    }
}

