/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zzhu;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int zzzH;
    private final String zzagC;
    private final String zzWF;
    private final Uri zzafY;
    private final Uri zzafZ;
    private final long zzagD;
    private final int zzagE;
    private final long zzagF;
    private final String zzagj;
    private final String zzagk;
    private final String zzWn;
    private final MostRecentGameInfoEntity zzagG;
    private final PlayerLevelInfo zzagH;
    private final boolean zzagI;
    private final boolean zzagJ;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean isPlusEnabled) {
        this.zzzH = 12;
        this.zzagC = isPlusEnabled ? player.getPlayerId() : null;
        this.zzWF = player.getDisplayName();
        this.zzafY = player.getIconImageUri();
        this.zzagj = player.getIconImageUrl();
        this.zzafZ = player.getHiResImageUri();
        this.zzagk = player.getHiResImageUrl();
        this.zzagD = player.getRetrievedTimestamp();
        this.zzagE = player.zzpT();
        this.zzagF = player.getLastPlayedWithTimestamp();
        this.zzWn = player.getTitle();
        this.zzagI = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.zzpU();
        this.zzagG = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzagH = player.getLevelInfo();
        this.zzagJ = player.zzpS();
        if (isPlusEnabled) {
            zzb.zzn((Object)this.zzagC);
        }
        zzb.zzn((Object)this.zzWF);
        zzb.zzP((this.zzagD > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess) {
        this.zzzH = versionCode;
        this.zzagC = playerId;
        this.zzWF = displayName;
        this.zzafY = iconImageUri;
        this.zzagj = iconImageUrl;
        this.zzafZ = hiResImageUri;
        this.zzagk = hiResImageUrl;
        this.zzagD = retrievedTimestamp;
        this.zzagE = isInCircles;
        this.zzagF = lastPlayedWithTimestamp;
        this.zzWn = title;
        this.zzagI = isProfileVisible;
        this.zzagG = mostRecentGameInfo;
        this.zzagH = playerLevelInfo;
        this.zzagJ = hasDebugAccess;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getPlayerId() {
        return this.zzagC;
    }

    @Override
    public String getDisplayName() {
        return this.zzWF;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzWF, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean zzpS() {
        return this.zzagJ;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzafY;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzagj;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzafZ;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzagk;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzagD;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzagF;
    }

    @Override
    public int zzpT() {
        return this.zzagE;
    }

    @Override
    public boolean isProfileVisible() {
        return this.zzagI;
    }

    @Override
    public String getTitle() {
        return this.zzWn;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzWn, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzagH;
    }

    @Override
    public MostRecentGameInfo zzpU() {
        return this.zzagG;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzu.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzpS(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzu.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzu.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzu.equal((Object)player2.zzpS(), (Object)player.zzpS()) && zzu.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzu.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzu.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzu.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzu.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzu.zzq((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzpS()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzagC);
            dest.writeString(this.zzWF);
            dest.writeString(this.zzafY == null ? null : this.zzafY.toString());
            dest.writeString(this.zzafZ == null ? null : this.zzafZ.toString());
            dest.writeLong(this.zzagD);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzde(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zzlP());
            if (bl || PlayerEntity.zzbK((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzde(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            int n = -1;
            long l2 = -1L;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            return new PlayerEntity(12, string, string2, uri, uri2, l, n, l2, string5, string6, string7, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzde(x0);
        }
    }
}

