/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzagR;
    private final PlayerLevelInfo zzagH;
    private final MostRecentGameInfoRef zzagS;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzagR = new PlayerColumnNames(prefix);
        this.zzagS = new MostRecentGameInfoRef(holder, dataRow, this.zzagR);
        if (this.zzpV()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzagR.zzams);
            int n2 = this.getInteger(this.zzagR.zzamv);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzagR.zzamt), this.getLong(this.zzagR.zzamu));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzagR.zzamu), this.getLong(this.zzagR.zzamw));
            }
            this.zzagH = new PlayerLevelInfo(this.getLong(this.zzagR.zzamr), this.getLong(this.zzagR.zzamx), playerLevel, playerLevel2);
        } else {
            this.zzagH = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzagR.zzami);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzagR.zzamj);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzagR.zzamj, dataOut);
    }

    @Override
    public boolean zzpS() {
        return this.getBoolean(this.zzagR.zzamH);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzbG(this.zzagR.zzamk);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzagR.zzaml);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzbG(this.zzagR.zzamm);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzagR.zzamn);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzagR.zzamo);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzbF(this.zzagR.zzamq) || this.zzbH(this.zzagR.zzamq)) {
            return -1L;
        }
        return this.getLong(this.zzagR.zzamq);
    }

    @Override
    public int zzpT() {
        return this.getInteger(this.zzagR.zzamp);
    }

    @Override
    public boolean isProfileVisible() {
        return this.getBoolean(this.zzagR.zzamA);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzagR.zzamy);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzagR.zzamy, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzagH;
    }

    @Override
    public MostRecentGameInfo zzpU() {
        if (this.zzbH(this.zzagR.zzamB)) {
            return null;
        }
        return this.zzagS;
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zzpV() {
        if (this.zzbH(this.zzagR.zzamr)) {
            return false;
        }
        return this.getLong(this.zzagR.zzamr) != -1L;
    }
}

