/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int zzzH;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzahp;
    private final ArrayList<AppContentConditionEntity> zzahf;
    private final String zzahg;
    private final int zzahq;
    private final String zzadH;
    private final Bundle mExtras;
    private final String zzahr;
    private final String zzWn;
    private final int zzahs;
    private final String zzAV;
    private final String zzGM;

    public AppContentCardEntity(AppContentCard card) {
        this.zzzH = 4;
        this.zzahg = card.zzpY();
        this.zzahq = card.zzqj();
        this.zzadH = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzGM = card.getId();
        this.zzWn = card.getTitle();
        this.zzahr = card.zzqk();
        this.zzahs = card.zzql();
        this.zzAV = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zzqi();
        int n2 = list2.size();
        this.zzahp = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzahp.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zzpX();
        int n3 = list3.size();
        this.zzahf = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzahf.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.zzzH = versionCode;
        this.mActions = actions;
        this.zzahp = annotations;
        this.zzahf = conditions;
        this.zzahg = contentDescription;
        this.zzahq = currentProgress;
        this.zzadH = description;
        this.mExtras = extras;
        this.zzGM = id;
        this.zzahr = subtitle;
        this.zzWn = title;
        this.zzahs = totalProgress;
        this.zzAV = type;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzqi() {
        return new ArrayList<AppContentAnnotation>(this.zzahp);
    }

    @Override
    public List<AppContentCondition> zzpX() {
        return new ArrayList<AppContentCondition>(this.zzahf);
    }

    @Override
    public String zzpY() {
        return this.zzahg;
    }

    @Override
    public int zzqj() {
        return this.zzahq;
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzGM;
    }

    @Override
    public String zzqk() {
        return this.zzahr;
    }

    @Override
    public String getTitle() {
        return this.zzWn;
    }

    @Override
    public int zzql() {
        return this.zzahs;
    }

    @Override
    public String getType() {
        return this.zzAV;
    }

    public AppContentCard zzqm() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzu.hashCode((Object[])new Object[]{appContentCard.getActions(), appContentCard.zzqi(), appContentCard.zzpX(), appContentCard.zzpY(), appContentCard.zzqj(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zzqk(), appContentCard.getTitle(), appContentCard.zzql(), appContentCard.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzu.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzu.equal(appContentCard2.zzqi(), appContentCard.zzqi()) && zzu.equal(appContentCard2.zzpX(), appContentCard.zzpX()) && zzu.equal((Object)appContentCard2.zzpY(), (Object)appContentCard.zzpY()) && zzu.equal((Object)appContentCard2.zzqj(), (Object)appContentCard.zzqj()) && zzu.equal((Object)appContentCard2.getDescription(), (Object)appContentCard.getDescription()) && zzu.equal((Object)appContentCard2.getExtras(), (Object)appContentCard.getExtras()) && zzu.equal((Object)appContentCard2.getId(), (Object)appContentCard.getId()) && zzu.equal((Object)appContentCard2.zzqk(), (Object)appContentCard.zzqk()) && zzu.equal((Object)appContentCard2.getTitle(), (Object)appContentCard.getTitle()) && zzu.equal((Object)appContentCard2.zzql(), (Object)appContentCard.zzql()) && zzu.equal((Object)appContentCard2.getType(), (Object)appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzu.zzq((Object)appContentCard).zzg("Actions", appContentCard.getActions()).zzg("Annotations", appContentCard.zzqi()).zzg("Conditions", appContentCard.zzpX()).zzg("ContentDescription", (Object)appContentCard.zzpY()).zzg("CurrentSteps", (Object)appContentCard.zzqj()).zzg("Description", (Object)appContentCard.getDescription()).zzg("Extras", (Object)appContentCard.getExtras()).zzg("Id", (Object)appContentCard.getId()).zzg("Subtitle", (Object)appContentCard.zzqk()).zzg("Title", (Object)appContentCard.getTitle()).zzg("TotalSteps", (Object)appContentCard.zzql()).zzg("Type", (Object)appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzqm();
    }
}

