/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.GamesClientImpl;

public final class PlayersImpl
implements Players {
    @Override
    public String getCurrentPlayerId(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzqF();
    }

    @Override
    public Player getCurrentPlayer(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzqG();
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadPlayer(GoogleApiClient apiClient, final String playerId) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, playerId, false);
            }
        });
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadPlayer(GoogleApiClient apiClient, final String playerId, final boolean forceReload) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, playerId, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadInvitablePlayers(GoogleApiClient apiClient, final int pageSize, final boolean forceReload) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, pageSize, false, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadMoreInvitablePlayers(GoogleApiClient apiClient, final int pageSize) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, pageSize, true, false);
            }
        });
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadRecentlyPlayedWithPlayers(GoogleApiClient apiClient, final int pageSize, final boolean forceReload) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, "played_with", pageSize, false, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadMoreRecentlyPlayedWithPlayers(GoogleApiClient apiClient, final int pageSize) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, "played_with", pageSize, true, false);
            }
        });
    }

    @Override
    public PendingResult<Players.LoadPlayersResult> loadConnectedPlayers(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza((zza.zza)new LoadPlayersImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Players.LoadPlayersResult>)this, forceReload);
            }
        });
    }

    @Override
    public Intent getCompareProfileIntent(GoogleApiClient apiClient, Player player) {
        return Games.zzd(apiClient).zza(new PlayerEntity(player));
    }

    @Override
    public Intent getPlayerSearchIntent(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzqQ();
    }

    private static abstract class UpdateProfileSettingsResultImpl
    extends Games.BaseGamesApiMethodImpl<Status> {
        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class LoadProfileSettingsResultImpl
    extends Games.BaseGamesApiMethodImpl<Players.LoadProfileSettingsResult> {
        protected Players.LoadProfileSettingsResult zzae(final Status status) {
            return new Players.LoadProfileSettingsResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean isProfileVisible() {
                    return true;
                }

                @Override
                public boolean isVisibilityExplicitlySet() {
                    return false;
                }
            };
        }

        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzae(x0);
        }
    }

    private static abstract class LoadXpStreamResultImpl
    extends Games.BaseGamesApiMethodImpl<Players.LoadXpStreamResult> {
        public Players.LoadXpStreamResult zzag(final Status status) {
            return new Players.LoadXpStreamResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzag(x0);
        }
    }

    private static abstract class LoadXpForGameCategoriesResultImpl
    extends Games.BaseGamesApiMethodImpl<Players.LoadXpForGameCategoriesResult> {
        public Players.LoadXpForGameCategoriesResult zzaf(final Status status) {
            return new Players.LoadXpForGameCategoriesResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaf(x0);
        }
    }

    private static abstract class LoadPlayersImpl
    extends Games.BaseGamesApiMethodImpl<Players.LoadPlayersResult> {
        private LoadPlayersImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Players.LoadPlayersResult zzad(final Status status) {
            return new Players.LoadPlayersResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public PlayerBuffer getPlayers() {
                    return new PlayerBuffer(DataHolder.zzaE((int)14));
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzad(x0);
        }
    }
}

