/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RequestsImpl
implements Requests {
    @Override
    public void registerRequestListener(GoogleApiClient apiClient, OnRequestReceivedListener listener) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzi zzi2 = apiClient.zzl((Object)listener);
            gamesClientImpl.zzd((zzi<OnRequestReceivedListener>)zzi2);
        }
    }

    @Override
    public void unregisterRequestListener(GoogleApiClient apiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzqP();
        }
    }

    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzqV();
    }

    @Override
    public Intent getSendIntent(GoogleApiClient apiClient, int type, byte[] payload, int requestLifetimeDays, Bitmap icon, String description) {
        return Games.zzd(apiClient).zza(type, payload, requestLifetimeDays, icon, description);
    }

    @Override
    public int getMaxPayloadSize(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzqW();
    }

    @Override
    public int getMaxLifetimeDays(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzqX();
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.acceptRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.zzb((zza.zza)new UpdateRequestsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zza.zzb<Requests.UpdateRequestsResult>)this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.dismissRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.zzb((zza.zza)new UpdateRequestsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc((zza.zzb<Requests.UpdateRequestsResult>)this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.LoadRequestsResult> loadRequests(GoogleApiClient apiClient, final int requestDirection, final int types, final int sortOrder) {
        return apiClient.zza((zza.zza)new LoadRequestsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Requests.LoadRequestsResult>)this, requestDirection, types, sortOrder);
            }
        });
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromInboxResponse(Intent response) {
        if (response == null) {
            return new ArrayList<GameRequest>();
        }
        return this.getGameRequestsFromBundle(response.getExtras());
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromBundle(Bundle extras) {
        if (extras == null || !extras.containsKey("requests")) {
            return new ArrayList<GameRequest>();
        }
        ArrayList arrayList = (ArrayList)extras.get("requests");
        ArrayList<GameRequest> arrayList2 = new ArrayList<GameRequest>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add((GameRequest)arrayList.get(i));
        }
        return arrayList2;
    }

    private static abstract class LoadRequestSummariesImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestSummariesResult> {
        public Requests.LoadRequestSummariesResult zzak(final Status status) {
            return new Requests.LoadRequestSummariesResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzak(x0);
        }
    }

    private static abstract class SendRequestImpl
    extends Games.BaseGamesApiMethodImpl<Requests.SendRequestResult> {
        public Requests.SendRequestResult zzam(final Status status) {
            return new Requests.SendRequestResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzam(x0);
        }
    }

    private static abstract class UpdateRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.UpdateRequestsResult> {
        private UpdateRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.UpdateRequestsResult zzan(final Status status) {
            return new Requests.UpdateRequestsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public int getRequestOutcome(String requestId) {
                    throw new IllegalArgumentException("Unknown request ID " + requestId);
                }

                @Override
                public Set<String> getRequestIds() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzan(x0);
        }
    }

    private static abstract class LoadRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestsResult> {
        private LoadRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.LoadRequestsResult zzal(final Status status) {
            return new Requests.LoadRequestsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public GameRequestBuffer getRequests(int type) {
                    int n = status.getStatusCode();
                    return new GameRequestBuffer(DataHolder.zzaE((int)n));
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzal(x0);
        }
    }
}

