/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int zzzH;
    private int zzMG;
    private String zzWn;
    private String zzadH;
    private Uri zzafY;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.zzzH = 1;
        this.zzMG = gameBadge.getType();
        this.zzWn = gameBadge.getTitle();
        this.zzadH = gameBadge.getDescription();
        this.zzafY = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.zzzH = versionCode;
        this.zzMG = type;
        this.zzWn = title;
        this.zzadH = description;
        this.zzafY = iconImageUri;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public int getType() {
        return this.zzMG;
    }

    @Override
    public String getTitle() {
        return this.zzWn;
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzafY;
    }

    public GameBadge zzrD() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzu.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzu.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzu.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzu.zzq((Object)gameBadge).zzg("Type", (Object)gameBadge.getType()).zzg("Title", (Object)gameBadge.getTitle()).zzg("Description", (Object)gameBadge.getDescription()).zzg("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzMG);
            dest.writeString(this.zzWn);
            dest.writeString(this.zzadH);
            dest.writeString(this.zzafY == null ? null : this.zzafY.toString());
        }
    }

    public /* synthetic */ Object freeze() {
        return this.zzrD();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzdo(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zzlP());
            if (bl || GameBadgeEntity.zzbK((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzdo(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdo(x0);
        }
    }
}

