/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import java.util.ArrayList;

public final class InvitationRef
extends zzc
implements Invitation {
    private final Game zzamO;
    private final ParticipantRef zzanw;
    private final ArrayList<Participant> zzant;

    InvitationRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.zzamO = new GameRef(holder, dataRow);
        this.zzant = new ArrayList(numChildren);
        ParticipantRef participantRef = null;
        String string = this.getString("external_inviter_id");
        for (int i = 0; i < numChildren; ++i) {
            ParticipantRef participantRef2 = new ParticipantRef(this.zzPy, this.zzRw + i);
            if (participantRef2.getParticipantId().equals(string)) {
                participantRef = participantRef2;
            }
            this.zzant.add(participantRef2);
        }
        this.zzanw = (ParticipantRef)zzv.zzb(participantRef, (Object)"Must have a valid inviter!");
    }

    @Override
    public Game getGame() {
        return this.zzamO;
    }

    @Override
    public String getInvitationId() {
        return this.getString("external_invitation_id");
    }

    @Override
    public Participant getInviter() {
        return this.zzanw;
    }

    @Override
    public long getCreationTimestamp() {
        long l = this.getLong("creation_timestamp");
        long l2 = this.getLong("last_modified_timestamp");
        return Math.max(l, l2);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.zzant;
    }

    @Override
    public int getInvitationType() {
        return this.getInteger("type");
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    public Invitation freeze() {
        return new InvitationEntity(this);
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return InvitationEntity.zza(this, obj);
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        InvitationEntity invitationEntity = (InvitationEntity)this.freeze();
        invitationEntity.writeToParcel(dest, flags);
    }
}

