/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.zzhu;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int zzzH;
    private final String zzaih;
    private final String zzanM;
    private final long zzanq;
    private final int zzanN;
    private final String zzadH;
    private final int zzanu;
    private final Bundle zzanK;
    private final ArrayList<ParticipantEntity> zzant;
    private final int zzanO;

    public RoomEntity(Room room) {
        this.zzzH = 2;
        this.zzaih = room.getRoomId();
        this.zzanM = room.getCreatorId();
        this.zzanq = room.getCreationTimestamp();
        this.zzanN = room.getStatus();
        this.zzadH = room.getDescription();
        this.zzanu = room.getVariant();
        this.zzanK = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzant = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzant.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzanO = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.zzzH = versionCode;
        this.zzaih = roomId;
        this.zzanM = creatorId;
        this.zzanq = creationTimestamp;
        this.zzanN = roomStatus;
        this.zzadH = description;
        this.zzanu = variant;
        this.zzanK = autoMatchCriteria;
        this.zzant = participants;
        this.zzanO = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getRoomId() {
        return this.zzaih;
    }

    @Override
    public String getCreatorId() {
        return this.zzanM;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzanq;
    }

    @Override
    public int getStatus() {
        return this.zzanN;
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzanu;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzanK;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzant);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzanO;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.zza((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.zzc(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzu.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.zza((Room)this, obj);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzu.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzu.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzu.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzu.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzu.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzu.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzu.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzu.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzu.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzu.zzq((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            RoomEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaih);
            dest.writeString(this.zzanM);
            dest.writeLong(this.zzanq);
            dest.writeInt(this.zzanN);
            dest.writeString(this.zzadH);
            dest.writeInt(this.zzanu);
            dest.writeBundle(this.zzanK);
            int n = this.zzant.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzant.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzdv(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzd(RoomEntity.zzlP());
            if (bl || RoomEntity.zzbK((String)RoomEntity.class.getCanonicalName())) {
                return super.zzdv(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdv(x0);
        }
    }
}

