/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzanP;
    private final TurnBasedMatchBuffer zzanQ;
    private final TurnBasedMatchBuffer zzanR;
    private final TurnBasedMatchBuffer zzanS;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzanP = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzanQ = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzanR = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzanS = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzeZ(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzanP;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzanQ;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzanR;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzanS;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzanP != null) {
            this.zzanP.release();
        }
        if (this.zzanQ != null) {
            this.zzanQ.release();
        }
        if (this.zzanR != null) {
            this.zzanR.release();
        }
        if (this.zzanS != null) {
            this.zzanS.release();
        }
    }

    public boolean hasData() {
        if (this.zzanP != null && this.zzanP.getCount() > 0) {
            return true;
        }
        if (this.zzanQ != null && this.zzanQ.getCount() > 0) {
            return true;
        }
        if (this.zzanR != null && this.zzanR.getCount() > 0) {
            return true;
        }
        return this.zzanS != null && this.zzanS.getCount() > 0;
    }
}

