/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfigImpl;
import java.util.ArrayList;

public abstract class TurnBasedMatchConfig {
    protected TurnBasedMatchConfig() {
    }

    public abstract int getVariant();

    public abstract int zzsh();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int zzanu = -1;
        ArrayList<String> zzanJ = new ArrayList();
        Bundle zzanK = null;
        int zzanT = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            zzv.zzr((Object)playerId);
            this.zzanJ.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            zzv.zzr(playerIds);
            this.zzanJ.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            zzv.zzb((variant == -1 || variant > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.zzanu = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.zzanK = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfigImpl(this);
        }
    }
}

