/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zzhu;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int zzzH;
    private final GameEntity zzalP;
    private final String zzaoh;
    private final long zzaoi;
    private final Uri zzaoj;
    private final String zzaok;
    private final String zzadH;
    private final long zzaol;
    private final long zzahd;
    private final Uri zzaom;
    private final String zzaon;
    private final String mName;
    private final long zzaoo;
    private final long zzaop;
    private final int mState;
    private final int zzMG;
    private final ArrayList<MilestoneEntity> zzaoq;

    public QuestEntity(Quest quest) {
        this.zzzH = 2;
        this.zzalP = new GameEntity(quest.getGame());
        this.zzaoh = quest.getQuestId();
        this.zzaoi = quest.getAcceptedTimestamp();
        this.zzadH = quest.getDescription();
        this.zzaoj = quest.getBannerImageUri();
        this.zzaok = quest.getBannerImageUrl();
        this.zzaol = quest.getEndTimestamp();
        this.zzaom = quest.getIconImageUri();
        this.zzaon = quest.getIconImageUrl();
        this.zzahd = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzaoo = quest.zzsk();
        this.zzaop = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzMG = quest.getType();
        List<Milestone> list = quest.zzsj();
        int n = list.size();
        this.zzaoq = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaoq.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.zzzH = versionCode;
        this.zzalP = game;
        this.zzaoh = questId;
        this.zzaoi = acceptedTimestamp;
        this.zzaoj = bannerImageUri;
        this.zzaok = bannerImageUrl;
        this.zzadH = description;
        this.zzaol = endTimestamp;
        this.zzahd = lastUpdatedTimestamp;
        this.zzaom = iconImageUri;
        this.zzaon = iconImageUrl;
        this.mName = name;
        this.zzaoo = notifyTimestamp;
        this.zzaop = startTimestamp;
        this.mState = state;
        this.zzMG = type;
        this.zzaoq = milestones;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getQuestId() {
        return this.zzaoh;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaom;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaon;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzaoj;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzaok;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzsj().get(0);
    }

    @Override
    public List<Milestone> zzsj() {
        return new ArrayList<Milestone>(this.zzaoq);
    }

    @Override
    public Game getGame() {
        return this.zzalP;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzMG;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzaoi;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzaol;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzahd;
    }

    @Override
    public long zzsk() {
        return this.zzaoo;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzaop;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzaoo <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzu.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzsj(), quest.getName(), quest.zzsk(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzu.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzu.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzu.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzu.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzu.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzu.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzu.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzu.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzu.equal(quest2.zzsj(), quest.zzsj()) && zzu.equal((Object)quest2.getName(), (Object)quest.getName()) && zzu.equal((Object)quest2.zzsk(), (Object)quest.zzsk()) && zzu.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzu.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzu.zzq((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzsj()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzsk()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

