/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int zzzH;
    private final GameEntity zzalP;
    private final PlayerEntity zzaor;
    private final byte[] zzanX;
    private final String zzAu;
    private final ArrayList<PlayerEntity> zzaos;
    private final int zzMG;
    private final long zzanq;
    private final long zzaot;
    private final Bundle zzaou;
    private final int zzue;

    public GameRequestEntity(GameRequest request) {
        this.zzzH = 2;
        this.zzalP = new GameEntity(request.getGame());
        this.zzaor = new PlayerEntity(request.getSender());
        this.zzAu = request.getRequestId();
        this.zzMG = request.getType();
        this.zzanq = request.getCreationTimestamp();
        this.zzaot = request.getExpirationTimestamp();
        this.zzue = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzanX = null;
        } else {
            this.zzanX = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzanX, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzaos = new ArrayList(n);
        this.zzaou = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzaos.add((PlayerEntity)player);
            this.zzaou.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.zzzH = versionCode;
        this.zzalP = game;
        this.zzaor = sender;
        this.zzanX = data;
        this.zzAu = requestId;
        this.zzaos = recipients;
        this.zzMG = type;
        this.zzanq = creationTimestamp;
        this.zzaot = expirationTimestamp;
        this.zzaou = recipientStatuses;
        this.zzue = status;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getRequestId() {
        return this.zzAu;
    }

    @Override
    public Game getGame() {
        return this.zzalP;
    }

    @Override
    public Player getSender() {
        return this.zzaor;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzaos);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzanX;
    }

    @Override
    public int getType() {
        return this.zzMG;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzanq;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzaot;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzaou.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzue;
    }

    public Bundle zzsl() {
        return this.zzaou;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzu.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzu.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzu.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzu.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzu.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzu.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzu.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzu.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzu.zzq((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

