/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract BitmapTeleporter zzsm();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzadH;
        private Long zzaoy;
        private Long zzaoz;
        private BitmapTeleporter zzaoA;
        private Uri zzaoB;

        public Builder setDescription(String description) {
            this.zzadH = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzaoy = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzaoz = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzaoA = new BitmapTeleporter(coverImage);
            this.zzaoB = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzadH = metadata.getDescription();
            this.zzaoy = metadata.getPlayedTime();
            this.zzaoz = metadata.getProgressValue();
            if (this.zzaoy == -1L) {
                this.zzaoy = null;
            }
            this.zzaoB = metadata.getCoverImageUri();
            if (this.zzaoB != null) {
                this.zzaoA = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzadH, this.zzaoy, this.zzaoA, this.zzaoB, this.zzaoz);
        }
    }
}

