/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;

public final class MilestoneRef
extends zzc
implements Milestone {
    MilestoneRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
    }

    @Override
    public String getMilestoneId() {
        return this.getString("external_milestone_id");
    }

    @Override
    public long getCurrentProgress() {
        switch (this.getState()) {
            case 3: 
            case 4: {
                return this.getTargetProgress();
            }
            case 1: {
                return 0L;
            }
            case 2: {
                return this.getLong("current_value") - this.zztM();
            }
        }
        return 0L;
    }

    @Override
    public String getEventId() {
        return this.getString("external_event_id");
    }

    private long zztM() {
        return this.getLong("initial_value");
    }

    @Override
    public long getTargetProgress() {
        return this.getLong("target_value");
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.getByteArray("completion_reward_data");
    }

    @Override
    public int getState() {
        return this.getInteger("milestone_state");
    }

    public Milestone freeze() {
        return new MilestoneEntity(this);
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.zza(this, obj);
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        MilestoneEntity milestoneEntity = (MilestoneEntity)this.freeze();
        milestoneEntity.writeToParcel(dest, flags);
    }
}

