/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntityCreator;
import com.google.android.gms.internal.zzlg;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class SnapshotContentsEntity
implements SafeParcelable,
SnapshotContents {
    private static final Object zzavj = new Object();
    public static final SnapshotContentsEntityCreator CREATOR = new SnapshotContentsEntityCreator();
    private final int zzCY;
    private Contents zzafa;

    public SnapshotContentsEntity(Contents contents) {
        this(1, contents);
    }

    SnapshotContentsEntity(int versionCode, Contents contents) {
        this.zzCY = versionCode;
        this.zzafa = contents;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        zzu.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Cannot mutate closed contents!");
        return this.zzafa.getParcelFileDescriptor();
    }

    @Override
    public Contents zzpe() {
        return this.zzafa;
    }

    @Override
    public void close() {
        this.zzafa = null;
    }

    @Override
    public boolean isClosed() {
        return this.zzafa == null;
    }

    @Override
    public byte[] readFully() throws IOException {
        zzu.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened Snapshot");
        Object object = zzavj;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzafa.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                byte[] byArray = zzlg.zza((InputStream)bufferedInputStream, (boolean)false);
                fileInputStream.getChannel().position(0L);
                return byArray;
            }
            catch (IOException iOException) {
                GamesLog.zzb("SnapshotContentsEntity", "Failed to read snapshot data", iOException);
                throw iOException;
            }
        }
    }

    @Override
    public boolean writeBytes(byte[] content) {
        return this.zza(0, content, 0, content.length, true);
    }

    @Override
    public boolean modifyBytes(int dstOffset, byte[] content, int srcOffset, int count) {
        return this.zza(dstOffset, content, srcOffset, content.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, byte[] byArray, int n2, int n3, boolean bl) {
        zzu.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened SnapshotContents");
        Object object = zzavj;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzafa.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n);
                ((OutputStream)bufferedOutputStream).write(byArray, n2, n3);
                if (bl) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                GamesLog.zza("SnapshotContentsEntity", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotContentsEntityCreator.zza(this, out, flags);
    }
}

