/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzayy;
    private final TurnBasedMatchBuffer zzayz;
    private final TurnBasedMatchBuffer zzayA;
    private final TurnBasedMatchBuffer zzayB;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzayy = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzayz = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzayA = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzayB = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzfQ(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzayy;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzayz;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzayA;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzayB;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzayy != null) {
            this.zzayy.release();
        }
        if (this.zzayz != null) {
            this.zzayz.release();
        }
        if (this.zzayA != null) {
            this.zzayA.release();
        }
        if (this.zzayB != null) {
            this.zzayB.release();
        }
    }

    public boolean hasData() {
        if (this.zzayy != null && this.zzayy.getCount() > 0) {
            return true;
        }
        if (this.zzayz != null && this.zzayz.getCount() > 0) {
            return true;
        }
        if (this.zzayA != null && this.zzayA.getCount() > 0) {
            return true;
        }
        return this.zzayB != null && this.zzayB.getCount() > 0;
    }
}

