/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract BitmapTeleporter zzvc();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzaoB;
        private Long zzazh;
        private Long zzazi;
        private BitmapTeleporter zzazj;
        private Uri zzazk;

        public Builder setDescription(String description) {
            this.zzaoB = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzazh = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzazi = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzazj = new BitmapTeleporter(coverImage);
            this.zzazk = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzaoB = metadata.getDescription();
            this.zzazh = metadata.getPlayedTime();
            this.zzazi = metadata.getProgressValue();
            if (this.zzazh == -1L) {
                this.zzazh = null;
            }
            this.zzazk = metadata.getCoverImageUri();
            if (this.zzazk != null) {
                this.zzazj = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzaoB, this.zzazh, this.zzazj, this.zzazk, this.zzazi);
        }
    }
}

