/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotMetadataRef
extends zzc
implements SnapshotMetadata {
    private final Game zzaxw;
    private final Player zzazv;

    public SnapshotMetadataRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.zzaxw = new GameRef(holder, dataRow);
        this.zzazv = new PlayerRef(holder, dataRow);
    }

    @Override
    public Game getGame() {
        return this.zzaxw;
    }

    @Override
    public Player getOwner() {
        return this.zzazv;
    }

    @Override
    public String getSnapshotId() {
        return this.getString("external_snapshot_id");
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzce("cover_icon_image_uri");
    }

    @Override
    public String getCoverImageUrl() {
        return this.getString("cover_icon_image_url");
    }

    @Override
    public float getCoverImageAspectRatio() {
        float f = this.getFloat("cover_icon_image_height");
        float f2 = this.getFloat("cover_icon_image_width");
        if (f == 0.0f) {
            return 0.0f;
        }
        return f2 / f;
    }

    @Override
    public String getUniqueName() {
        return this.getString("unique_name");
    }

    @Override
    public String getTitle() {
        return this.getString("title");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.zza("description", dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.getLong("last_modified_timestamp");
    }

    @Override
    public long getPlayedTime() {
        return this.getLong("duration");
    }

    @Override
    public boolean hasChangePending() {
        return this.getInteger("pending_change_count") > 0;
    }

    @Override
    public long getProgressValue() {
        return this.getLong("progress_value");
    }

    public SnapshotMetadata freeze() {
        return new SnapshotMetadataEntity(this);
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        SnapshotMetadataEntity snapshotMetadataEntity = (SnapshotMetadataEntity)this.freeze();
        snapshotMetadataEntity.writeToParcel(dest, flags);
    }
}

