/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzmo;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzUM;
    private final String zzTa;
    private final String zzatr;
    private final String zzats;
    private final String zzaqZ;
    private final String zzatt;
    private final Uri zzatu;
    private final Uri zzatv;
    private final Uri zzatw;
    private final boolean zzatx;
    private final boolean zzaty;
    private final String zzatz;
    private final int zzatA;
    private final int zzatB;
    private final int zzatC;
    private final boolean zzatD;
    private final boolean zzatE;
    private final String zzatF;
    private final String zzatG;
    private final String zzatH;
    private final boolean zzBa;
    private final boolean zzatI;
    private final boolean zzatJ;
    private final String zzatK;
    private final boolean zzatL;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzUM = game.getApplicationId();
        this.zzatr = game.getPrimaryCategory();
        this.zzats = game.getSecondaryCategory();
        this.zzaqZ = game.getDescription();
        this.zzatt = game.getDeveloperName();
        this.zzTa = game.getDisplayName();
        this.zzatu = game.getIconImageUri();
        this.zzatF = game.getIconImageUrl();
        this.zzatv = game.getHiResImageUri();
        this.zzatG = game.getHiResImageUrl();
        this.zzatw = game.getFeaturedImageUri();
        this.zzatH = game.getFeaturedImageUrl();
        this.zzatx = game.zztx();
        this.zzaty = game.zztz();
        this.zzatz = game.zztA();
        this.zzatA = game.zztB();
        this.zzatB = game.getAchievementTotalCount();
        this.zzatC = game.getLeaderboardCount();
        this.zzatD = game.isRealTimeMultiplayerEnabled();
        this.zzatE = game.isTurnBasedMultiplayerEnabled();
        this.zzBa = game.isMuted();
        this.zzatI = game.zzty();
        this.zzatJ = game.areSnapshotsEnabled();
        this.zzatK = game.getThemeColor();
        this.zzatL = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.mVersionCode = versionCode;
        this.zzUM = applicationId;
        this.zzTa = displayName;
        this.zzatr = primaryCategory;
        this.zzats = secondaryCategory;
        this.zzaqZ = description;
        this.zzatt = developerName;
        this.zzatu = iconImageUri;
        this.zzatF = iconImageUrl;
        this.zzatv = hiResImageUri;
        this.zzatG = hiResImageUrl;
        this.zzatw = featuredImageUri;
        this.zzatH = featuredImageUrl;
        this.zzatx = playEnabledGame;
        this.zzaty = instanceInstalled;
        this.zzatz = instancePackageName;
        this.zzatA = gameplayAclStatus;
        this.zzatB = achievementTotalCount;
        this.zzatC = leaderboardCount;
        this.zzatD = realTimeEnabled;
        this.zzatE = turnBasedEnabled;
        this.zzBa = muted;
        this.zzatI = identitySharingConfirmed;
        this.zzatJ = snapshotsEnabled;
        this.zzatK = themeColor;
        this.zzatL = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzUM;
    }

    @Override
    public String getDisplayName() {
        return this.zzTa;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzTa, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzatr;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzats;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzaqZ, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzatt;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzatt, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzatF;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzatv;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzatG;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzatw;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzatH;
    }

    @Override
    public boolean isMuted() {
        return this.zzBa;
    }

    @Override
    public boolean zzty() {
        return this.zzatI;
    }

    @Override
    public boolean zztx() {
        return this.zzatx;
    }

    @Override
    public boolean zztz() {
        return this.zzaty;
    }

    @Override
    public String zztA() {
        return this.zzatz;
    }

    @Override
    public int zztB() {
        return this.zzatA;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzatB;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzatC;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzatD;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzatE;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzatJ;
    }

    @Override
    public String getThemeColor() {
        return this.zzatK;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzatL;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzw.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zztx(), game.zztz(), game.zztA(), game.zztB(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzty(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzw.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzw.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzw.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzw.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzw.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzw.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzw.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzw.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzw.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzw.equal((Object)game2.zztx(), (Object)game.zztx()) && zzw.equal((Object)game2.zztz(), (Object)game.zztz()) && zzw.equal((Object)game2.zztA(), (Object)game.zztA()) && zzw.equal((Object)game2.zztB(), (Object)game.zztB()) && zzw.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzw.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzw.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzw.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzw.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzw.equal((Object)game2.zzty(), (Object)game.zzty()) ? 1 : 0)) && zzw.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzw.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzw.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzw.zzv((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zztx()).zzg("InstanceInstalled", (Object)game.zztz()).zzg("InstancePackageName", (Object)game.zztA()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzUM);
            dest.writeString(this.zzTa);
            dest.writeString(this.zzatr);
            dest.writeString(this.zzats);
            dest.writeString(this.zzaqZ);
            dest.writeString(this.zzatt);
            dest.writeString(this.zzatu == null ? null : this.zzatu.toString());
            dest.writeString(this.zzatv == null ? null : this.zzatv.toString());
            dest.writeString(this.zzatw == null ? null : this.zzatw.toString());
            dest.writeInt(this.zzatx ? 1 : 0);
            dest.writeInt(this.zzaty ? 1 : 0);
            dest.writeString(this.zzatz);
            dest.writeInt(this.zzatA);
            dest.writeInt(this.zzatB);
            dest.writeInt(this.zzatC);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzdN(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zzoT());
            if (bl || GameEntity.zzck((String)GameEntity.class.getCanonicalName())) {
                return super.zzdN(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdN(x0);
        }
    }
}

