/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;

public final class GameRef
extends zzc
implements Game {
    public GameRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
    }

    @Override
    public String getApplicationId() {
        return this.getString("external_game_id");
    }

    @Override
    public String getDisplayName() {
        return this.getString("display_name");
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza("display_name", dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.getString("primary_category");
    }

    @Override
    public String getSecondaryCategory() {
        return this.getString("secondary_category");
    }

    @Override
    public String getDescription() {
        return this.getString("game_description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.zza("game_description", dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.getString("developer_name");
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        this.zza("developer_name", dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzcf("game_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("game_icon_image_url");
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzcf("game_hi_res_image_uri");
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString("game_hi_res_image_url");
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzcf("featured_image_uri");
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.getString("featured_image_url");
    }

    @Override
    public boolean zztx() {
        return this.getBoolean("play_enabled_game");
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean("muted");
    }

    @Override
    public boolean zzty() {
        return this.getBoolean("identity_sharing_confirmed");
    }

    @Override
    public boolean zztz() {
        return this.getInteger("installed") > 0;
    }

    @Override
    public String zztA() {
        return this.getString("package_name");
    }

    @Override
    public int zztB() {
        return this.getInteger("gameplay_acl_status");
    }

    @Override
    public int getAchievementTotalCount() {
        return this.getInteger("achievement_total_count");
    }

    @Override
    public int getLeaderboardCount() {
        return this.getInteger("leaderboard_count");
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.getInteger("real_time_support") > 0;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.getInteger("turn_based_support") > 0;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.getInteger("snapshots_enabled") > 0;
    }

    @Override
    public String getThemeColor() {
        return this.getString("theme_color");
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.getInteger("gamepad_support") > 0;
    }

    public Game freeze() {
        return new GameEntity(this);
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameEntity gameEntity = (GameEntity)this.freeze();
        gameEntity.writeToParcel(dest, flags);
    }
}

