/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zzmo;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzYf;
    private final String zzTa;
    private final Uri zzatu;
    private final Uri zzatv;
    private final long zzatZ;
    private final int zzaua;
    private final long zzaub;
    private final String zzatF;
    private final String zzatG;
    private final String zzajf;
    private final MostRecentGameInfoEntity zzauc;
    private final PlayerLevelInfo zzaud;
    private final boolean zzaue;
    private final boolean zzauf;
    private final String zzaug;
    private final String mName;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean isPlusEnabled) {
        this.mVersionCode = 12;
        this.zzYf = isPlusEnabled ? player.getPlayerId() : null;
        this.zzTa = player.getDisplayName();
        this.zzatu = player.getIconImageUri();
        this.zzatF = player.getIconImageUrl();
        this.zzatv = player.getHiResImageUri();
        this.zzatG = player.getHiResImageUrl();
        this.zzatZ = player.getRetrievedTimestamp();
        this.zzaua = player.zztG();
        this.zzaub = player.getLastPlayedWithTimestamp();
        this.zzajf = player.getTitle();
        this.zzaue = player.zztH();
        MostRecentGameInfo mostRecentGameInfo = player.zztI();
        this.zzauc = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzaud = player.getLevelInfo();
        this.zzauf = player.zztF();
        this.zzaug = player.zztE();
        this.mName = player.getName();
        if (isPlusEnabled) {
            zzb.zzs((Object)this.zzYf);
        }
        zzb.zzs((Object)this.zzTa);
        zzb.zzZ((this.zzatZ > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess, String gamerTag, String name) {
        this.mVersionCode = versionCode;
        this.zzYf = playerId;
        this.zzTa = displayName;
        this.zzatu = iconImageUri;
        this.zzatF = iconImageUrl;
        this.zzatv = hiResImageUri;
        this.zzatG = hiResImageUrl;
        this.zzatZ = retrievedTimestamp;
        this.zzaua = isInCircles;
        this.zzaub = lastPlayedWithTimestamp;
        this.zzajf = title;
        this.zzaue = isProfileVisible;
        this.zzauc = mostRecentGameInfo;
        this.zzaud = playerLevelInfo;
        this.zzauf = hasDebugAccess;
        this.zzaug = gamerTag;
        this.mName = name;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.zzYf;
    }

    @Override
    public String getDisplayName() {
        return this.zzTa;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzTa, (CharArrayBuffer)dataOut);
    }

    @Override
    public String zztE() {
        return this.zzaug;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zztF() {
        return this.zzauf;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzatF;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzatv;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzatG;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzatZ;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzaub;
    }

    @Override
    public int zztG() {
        return this.zzaua;
    }

    @Override
    public boolean zztH() {
        return this.zzaue;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzajf, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaud;
    }

    @Override
    public MostRecentGameInfo zztI() {
        return this.zzauc;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzw.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zztF(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zztE(), player.getName()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzw.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzw.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzw.equal((Object)player2.zztF(), (Object)player.zztF()) && zzw.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzw.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzw.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzw.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzw.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzw.equal((Object)player2.zztE(), (Object)player.zztE()) && zzw.equal((Object)player2.getName(), (Object)player.getName());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzw.zzv((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zztF()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zztE()).zzg("Name", (Object)player.getName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzYf);
            dest.writeString(this.zzTa);
            dest.writeString(this.zzatu == null ? null : this.zzatu.toString());
            dest.writeString(this.zzatv == null ? null : this.zzatv.toString());
            dest.writeLong(this.zzatZ);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzdO(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zzoT());
            if (bl || PlayerEntity.zzck((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzdO(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            return new PlayerEntity(12, string, string2, uri, uri2, l, n, l2, string7, string8, string9, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3, string5, string6);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdO(x0);
        }
    }
}

